/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.CreateClusterRequest;
import com.amazonaws.services.snowball.model.transform.JobResourceJsonMarshaller;
import com.amazonaws.services.snowball.model.transform.NotificationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateClusterRequestMarshaller
implements Marshaller<Request<CreateClusterRequest>, CreateClusterRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateClusterRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateClusterRequest> marshall(CreateClusterRequest createClusterRequest) {
        if (createClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateClusterRequest> request = new DefaultRequest<CreateClusterRequest>(createClusterRequest, "AmazonSnowball");
        request.addHeader("X-Amz-Target", "AWSIESnowballJobManagementService.CreateCluster");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createClusterRequest.getJobType() != null) {
                jsonGenerator.writeFieldName("JobType").writeValue(createClusterRequest.getJobType());
            }
            if (createClusterRequest.getResources() != null) {
                jsonGenerator.writeFieldName("Resources");
                JobResourceJsonMarshaller.getInstance().marshall(createClusterRequest.getResources(), jsonGenerator);
            }
            if (createClusterRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createClusterRequest.getDescription());
            }
            if (createClusterRequest.getAddressId() != null) {
                jsonGenerator.writeFieldName("AddressId").writeValue(createClusterRequest.getAddressId());
            }
            if (createClusterRequest.getKmsKeyARN() != null) {
                jsonGenerator.writeFieldName("KmsKeyARN").writeValue(createClusterRequest.getKmsKeyARN());
            }
            if (createClusterRequest.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(createClusterRequest.getRoleARN());
            }
            if (createClusterRequest.getSnowballType() != null) {
                jsonGenerator.writeFieldName("SnowballType").writeValue(createClusterRequest.getSnowballType());
            }
            if (createClusterRequest.getShippingOption() != null) {
                jsonGenerator.writeFieldName("ShippingOption").writeValue(createClusterRequest.getShippingOption());
            }
            if (createClusterRequest.getNotification() != null) {
                jsonGenerator.writeFieldName("Notification");
                NotificationJsonMarshaller.getInstance().marshall(createClusterRequest.getNotification(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

