/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.StopAutomationExecutionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class StopAutomationExecutionRequestMarshaller
implements Marshaller<Request<StopAutomationExecutionRequest>, StopAutomationExecutionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public StopAutomationExecutionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<StopAutomationExecutionRequest> marshall(StopAutomationExecutionRequest stopAutomationExecutionRequest) {
        if (stopAutomationExecutionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StopAutomationExecutionRequest> request = new DefaultRequest<StopAutomationExecutionRequest>(stopAutomationExecutionRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.StopAutomationExecution");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (stopAutomationExecutionRequest.getAutomationExecutionId() != null) {
                jsonGenerator.writeFieldName("AutomationExecutionId").writeValue(stopAutomationExecutionRequest.getAutomationExecutionId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

