/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.servicecatalog.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreatePortfolioRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String acceptLanguage;
    private String displayName;
    private String description;
    private String providerName;
    private List<Tag> tags;
    private String idempotencyToken;

    public void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public CreatePortfolioRequest withAcceptLanguage(String acceptLanguage) {
        this.setAcceptLanguage(acceptLanguage);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public CreatePortfolioRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreatePortfolioRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public CreatePortfolioRequest withProviderName(String providerName) {
        this.setProviderName(providerName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreatePortfolioRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreatePortfolioRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    public CreatePortfolioRequest withIdempotencyToken(String idempotencyToken) {
        this.setIdempotencyToken(idempotencyToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAcceptLanguage() != null) {
            sb.append("AcceptLanguage: " + this.getAcceptLanguage() + ",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: " + this.getDisplayName() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getProviderName() != null) {
            sb.append("ProviderName: " + this.getProviderName() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getIdempotencyToken() != null) {
            sb.append("IdempotencyToken: " + this.getIdempotencyToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortfolioRequest)) {
            return false;
        }
        CreatePortfolioRequest other = (CreatePortfolioRequest)obj;
        if (other.getAcceptLanguage() == null ^ this.getAcceptLanguage() == null) {
            return false;
        }
        if (other.getAcceptLanguage() != null && !other.getAcceptLanguage().equals(this.getAcceptLanguage())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getProviderName() == null ^ this.getProviderName() == null) {
            return false;
        }
        if (other.getProviderName() != null && !other.getProviderName().equals(this.getProviderName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getIdempotencyToken() == null ^ this.getIdempotencyToken() == null) {
            return false;
        }
        return other.getIdempotencyToken() == null || other.getIdempotencyToken().equals(this.getIdempotencyToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAcceptLanguage() == null ? 0 : this.getAcceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getProviderName() == null ? 0 : this.getProviderName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getIdempotencyToken() == null ? 0 : this.getIdempotencyToken().hashCode());
        return hashCode;
    }

    @Override
    public CreatePortfolioRequest clone() {
        return (CreatePortfolioRequest)super.clone();
    }
}

