/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.services.rekognition.model.S3Object;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Image
implements Serializable,
Cloneable {
    private ByteBuffer bytes;
    private S3Object s3Object;

    public void setBytes(ByteBuffer bytes) {
        this.bytes = bytes;
    }

    public ByteBuffer getBytes() {
        return this.bytes;
    }

    public Image withBytes(ByteBuffer bytes) {
        this.setBytes(bytes);
        return this;
    }

    public void setS3Object(S3Object s3Object) {
        this.s3Object = s3Object;
    }

    public S3Object getS3Object() {
        return this.s3Object;
    }

    public Image withS3Object(S3Object s3Object) {
        this.setS3Object(s3Object);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBytes() != null) {
            sb.append("Bytes: " + this.getBytes() + ",");
        }
        if (this.getS3Object() != null) {
            sb.append("S3Object: " + this.getS3Object());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        if (other.getBytes() == null ^ this.getBytes() == null) {
            return false;
        }
        if (other.getBytes() != null && !other.getBytes().equals(this.getBytes())) {
            return false;
        }
        if (other.getS3Object() == null ^ this.getS3Object() == null) {
            return false;
        }
        return other.getS3Object() == null || other.getS3Object().equals(this.getS3Object());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBytes() == null ? 0 : this.getBytes().hashCode());
        hashCode = 31 * hashCode + (this.getS3Object() == null ? 0 : this.getS3Object().hashCode());
        return hashCode;
    }

    public Image clone() {
        try {
            return (Image)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

