/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.EndpointUser;
import java.util.List;
import java.util.Map;

public class EndpointUserJsonMarshaller {
    private static EndpointUserJsonMarshaller instance;

    public void marshall(EndpointUser endpointUser, StructuredJsonGenerator jsonGenerator) {
        if (endpointUser == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            Map<String, List<String>> userAttributesMap = endpointUser.getUserAttributes();
            if (userAttributesMap != null) {
                jsonGenerator.writeFieldName("UserAttributes");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> userAttributesMapValue : userAttributesMap.entrySet()) {
                    if (userAttributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(userAttributesMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String userAttributesMapValueList : userAttributesMapValue.getValue()) {
                        if (userAttributesMapValueList == null) continue;
                        jsonGenerator.writeValue(userAttributesMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (endpointUser.getUserId() != null) {
                jsonGenerator.writeFieldName("UserId").writeValue(endpointUser.getUserId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EndpointUserJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointUserJsonMarshaller();
        }
        return instance;
    }
}

