/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.StartInstanceRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class StartInstanceRequestMarshaller
implements Marshaller<Request<StartInstanceRequest>, StartInstanceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public StartInstanceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<StartInstanceRequest> marshall(StartInstanceRequest startInstanceRequest) {
        if (startInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StartInstanceRequest> request = new DefaultRequest<StartInstanceRequest>(startInstanceRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.StartInstance");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (startInstanceRequest.getInstanceName() != null) {
                jsonGenerator.writeFieldName("instanceName").writeValue(startInstanceRequest.getInstanceName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

