/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.CreateInstancesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateInstancesRequestMarshaller
implements Marshaller<Request<CreateInstancesRequest>, CreateInstancesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateInstancesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateInstancesRequest> marshall(CreateInstancesRequest createInstancesRequest) {
        if (createInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateInstancesRequest> request = new DefaultRequest<CreateInstancesRequest>(createInstancesRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.CreateInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> instanceNamesList = createInstancesRequest.getInstanceNames();
            if (instanceNamesList != null) {
                jsonGenerator.writeFieldName("instanceNames");
                jsonGenerator.writeStartArray();
                for (String instanceNamesListValue : instanceNamesList) {
                    if (instanceNamesListValue == null) continue;
                    jsonGenerator.writeValue(instanceNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createInstancesRequest.getAvailabilityZone() != null) {
                jsonGenerator.writeFieldName("availabilityZone").writeValue(createInstancesRequest.getAvailabilityZone());
            }
            if (createInstancesRequest.getCustomImageName() != null) {
                jsonGenerator.writeFieldName("customImageName").writeValue(createInstancesRequest.getCustomImageName());
            }
            if (createInstancesRequest.getBlueprintId() != null) {
                jsonGenerator.writeFieldName("blueprintId").writeValue(createInstancesRequest.getBlueprintId());
            }
            if (createInstancesRequest.getBundleId() != null) {
                jsonGenerator.writeFieldName("bundleId").writeValue(createInstancesRequest.getBundleId());
            }
            if (createInstancesRequest.getUserData() != null) {
                jsonGenerator.writeFieldName("userData").writeValue(createInstancesRequest.getUserData());
            }
            if (createInstancesRequest.getKeyPairName() != null) {
                jsonGenerator.writeFieldName("keyPairName").writeValue(createInstancesRequest.getKeyPairName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

