/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codebuild.model.Build;
import com.amazonaws.services.codebuild.model.BuildPhase;
import com.amazonaws.services.codebuild.model.transform.BuildArtifactsJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.BuildPhaseJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.LogsLocationJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.ProjectEnvironmentJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.ProjectSourceJsonMarshaller;
import java.util.List;

public class BuildJsonMarshaller {
    private static BuildJsonMarshaller instance;

    public void marshall(Build build, StructuredJsonGenerator jsonGenerator) {
        if (build == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<BuildPhase> phasesList;
            jsonGenerator.writeStartObject();
            if (build.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(build.getId());
            }
            if (build.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(build.getArn());
            }
            if (build.getStartTime() != null) {
                jsonGenerator.writeFieldName("startTime").writeValue(build.getStartTime());
            }
            if (build.getEndTime() != null) {
                jsonGenerator.writeFieldName("endTime").writeValue(build.getEndTime());
            }
            if (build.getCurrentPhase() != null) {
                jsonGenerator.writeFieldName("currentPhase").writeValue(build.getCurrentPhase());
            }
            if (build.getBuildStatus() != null) {
                jsonGenerator.writeFieldName("buildStatus").writeValue(build.getBuildStatus());
            }
            if (build.getSourceVersion() != null) {
                jsonGenerator.writeFieldName("sourceVersion").writeValue(build.getSourceVersion());
            }
            if (build.getProjectName() != null) {
                jsonGenerator.writeFieldName("projectName").writeValue(build.getProjectName());
            }
            if ((phasesList = build.getPhases()) != null) {
                jsonGenerator.writeFieldName("phases");
                jsonGenerator.writeStartArray();
                for (BuildPhase phasesListValue : phasesList) {
                    if (phasesListValue == null) continue;
                    BuildPhaseJsonMarshaller.getInstance().marshall(phasesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (build.getSource() != null) {
                jsonGenerator.writeFieldName("source");
                ProjectSourceJsonMarshaller.getInstance().marshall(build.getSource(), jsonGenerator);
            }
            if (build.getArtifacts() != null) {
                jsonGenerator.writeFieldName("artifacts");
                BuildArtifactsJsonMarshaller.getInstance().marshall(build.getArtifacts(), jsonGenerator);
            }
            if (build.getEnvironment() != null) {
                jsonGenerator.writeFieldName("environment");
                ProjectEnvironmentJsonMarshaller.getInstance().marshall(build.getEnvironment(), jsonGenerator);
            }
            if (build.getLogs() != null) {
                jsonGenerator.writeFieldName("logs");
                LogsLocationJsonMarshaller.getInstance().marshall(build.getLogs(), jsonGenerator);
            }
            if (build.getTimeoutInMinutes() != null) {
                jsonGenerator.writeFieldName("timeoutInMinutes").writeValue(build.getTimeoutInMinutes());
            }
            if (build.getBuildComplete() != null) {
                jsonGenerator.writeFieldName("buildComplete").writeValue(build.getBuildComplete());
            }
            if (build.getInitiator() != null) {
                jsonGenerator.writeFieldName("initiator").writeValue(build.getInitiator());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BuildJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BuildJsonMarshaller();
        }
        return instance;
    }
}

