/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudformation.AmazonCloudFormationAsync;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest;
import com.amazonaws.services.cloudformation.model.CancelUpdateStackResult;
import com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackRequest;
import com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackResult;
import com.amazonaws.services.cloudformation.model.CreateChangeSetRequest;
import com.amazonaws.services.cloudformation.model.CreateChangeSetResult;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteChangeSetRequest;
import com.amazonaws.services.cloudformation.model.DeleteChangeSetResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DeleteStackResult;
import com.amazonaws.services.cloudformation.model.DescribeAccountLimitsRequest;
import com.amazonaws.services.cloudformation.model.DescribeAccountLimitsResult;
import com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest;
import com.amazonaws.services.cloudformation.model.DescribeChangeSetResult;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest;
import com.amazonaws.services.cloudformation.model.EstimateTemplateCostResult;
import com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest;
import com.amazonaws.services.cloudformation.model.ExecuteChangeSetResult;
import com.amazonaws.services.cloudformation.model.GetStackPolicyRequest;
import com.amazonaws.services.cloudformation.model.GetStackPolicyResult;
import com.amazonaws.services.cloudformation.model.GetTemplateRequest;
import com.amazonaws.services.cloudformation.model.GetTemplateResult;
import com.amazonaws.services.cloudformation.model.GetTemplateSummaryRequest;
import com.amazonaws.services.cloudformation.model.GetTemplateSummaryResult;
import com.amazonaws.services.cloudformation.model.ListChangeSetsRequest;
import com.amazonaws.services.cloudformation.model.ListChangeSetsResult;
import com.amazonaws.services.cloudformation.model.ListExportsRequest;
import com.amazonaws.services.cloudformation.model.ListExportsResult;
import com.amazonaws.services.cloudformation.model.ListImportsRequest;
import com.amazonaws.services.cloudformation.model.ListImportsResult;
import com.amazonaws.services.cloudformation.model.ListStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.ListStackResourcesResult;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.services.cloudformation.model.ListStacksResult;
import com.amazonaws.services.cloudformation.model.SetStackPolicyRequest;
import com.amazonaws.services.cloudformation.model.SetStackPolicyResult;
import com.amazonaws.services.cloudformation.model.SignalResourceRequest;
import com.amazonaws.services.cloudformation.model.SignalResourceResult;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackResult;
import com.amazonaws.services.cloudformation.model.ValidateTemplateRequest;
import com.amazonaws.services.cloudformation.model.ValidateTemplateResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCloudFormationAsyncClient
extends AmazonCloudFormationClient
implements AmazonCloudFormationAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonCloudFormationAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    public AmazonCloudFormationAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudFormationAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudFormationAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonCloudFormationAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCloudFormationAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudFormationAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudFormationAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonCloudFormationAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonCloudFormationAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelUpdateStackResult> cancelUpdateStackAsync(CancelUpdateStackRequest request) {
        return this.cancelUpdateStackAsync(request, null);
    }

    @Override
    public Future<CancelUpdateStackResult> cancelUpdateStackAsync(final CancelUpdateStackRequest request, final AsyncHandler<CancelUpdateStackRequest, CancelUpdateStackResult> asyncHandler) {
        return this.executorService.submit(new Callable<CancelUpdateStackResult>(){

            @Override
            public CancelUpdateStackResult call() throws Exception {
                CancelUpdateStackResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.cancelUpdateStack(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ContinueUpdateRollbackResult> continueUpdateRollbackAsync(ContinueUpdateRollbackRequest request) {
        return this.continueUpdateRollbackAsync(request, null);
    }

    @Override
    public Future<ContinueUpdateRollbackResult> continueUpdateRollbackAsync(final ContinueUpdateRollbackRequest request, final AsyncHandler<ContinueUpdateRollbackRequest, ContinueUpdateRollbackResult> asyncHandler) {
        return this.executorService.submit(new Callable<ContinueUpdateRollbackResult>(){

            @Override
            public ContinueUpdateRollbackResult call() throws Exception {
                ContinueUpdateRollbackResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.continueUpdateRollback(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateChangeSetResult> createChangeSetAsync(CreateChangeSetRequest request) {
        return this.createChangeSetAsync(request, null);
    }

    @Override
    public Future<CreateChangeSetResult> createChangeSetAsync(final CreateChangeSetRequest request, final AsyncHandler<CreateChangeSetRequest, CreateChangeSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateChangeSetResult>(){

            @Override
            public CreateChangeSetResult call() throws Exception {
                CreateChangeSetResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.createChangeSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStackResult> createStackAsync(CreateStackRequest request) {
        return this.createStackAsync(request, null);
    }

    @Override
    public Future<CreateStackResult> createStackAsync(final CreateStackRequest request, final AsyncHandler<CreateStackRequest, CreateStackResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateStackResult>(){

            @Override
            public CreateStackResult call() throws Exception {
                CreateStackResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.createStack(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteChangeSetResult> deleteChangeSetAsync(DeleteChangeSetRequest request) {
        return this.deleteChangeSetAsync(request, null);
    }

    @Override
    public Future<DeleteChangeSetResult> deleteChangeSetAsync(final DeleteChangeSetRequest request, final AsyncHandler<DeleteChangeSetRequest, DeleteChangeSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteChangeSetResult>(){

            @Override
            public DeleteChangeSetResult call() throws Exception {
                DeleteChangeSetResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.deleteChangeSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStackResult> deleteStackAsync(DeleteStackRequest request) {
        return this.deleteStackAsync(request, null);
    }

    @Override
    public Future<DeleteStackResult> deleteStackAsync(final DeleteStackRequest request, final AsyncHandler<DeleteStackRequest, DeleteStackResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteStackResult>(){

            @Override
            public DeleteStackResult call() throws Exception {
                DeleteStackResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.deleteStack(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccountLimitsResult> describeAccountLimitsAsync(DescribeAccountLimitsRequest request) {
        return this.describeAccountLimitsAsync(request, null);
    }

    @Override
    public Future<DescribeAccountLimitsResult> describeAccountLimitsAsync(final DescribeAccountLimitsRequest request, final AsyncHandler<DescribeAccountLimitsRequest, DescribeAccountLimitsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAccountLimitsResult>(){

            @Override
            public DescribeAccountLimitsResult call() throws Exception {
                DescribeAccountLimitsResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeAccountLimits(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeChangeSetResult> describeChangeSetAsync(DescribeChangeSetRequest request) {
        return this.describeChangeSetAsync(request, null);
    }

    @Override
    public Future<DescribeChangeSetResult> describeChangeSetAsync(final DescribeChangeSetRequest request, final AsyncHandler<DescribeChangeSetRequest, DescribeChangeSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeChangeSetResult>(){

            @Override
            public DescribeChangeSetResult call() throws Exception {
                DescribeChangeSetResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeChangeSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStackEventsResult> describeStackEventsAsync(DescribeStackEventsRequest request) {
        return this.describeStackEventsAsync(request, null);
    }

    @Override
    public Future<DescribeStackEventsResult> describeStackEventsAsync(final DescribeStackEventsRequest request, final AsyncHandler<DescribeStackEventsRequest, DescribeStackEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeStackEventsResult>(){

            @Override
            public DescribeStackEventsResult call() throws Exception {
                DescribeStackEventsResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeStackEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStackResourceResult> describeStackResourceAsync(DescribeStackResourceRequest request) {
        return this.describeStackResourceAsync(request, null);
    }

    @Override
    public Future<DescribeStackResourceResult> describeStackResourceAsync(final DescribeStackResourceRequest request, final AsyncHandler<DescribeStackResourceRequest, DescribeStackResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeStackResourceResult>(){

            @Override
            public DescribeStackResourceResult call() throws Exception {
                DescribeStackResourceResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeStackResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStackResourcesResult> describeStackResourcesAsync(DescribeStackResourcesRequest request) {
        return this.describeStackResourcesAsync(request, null);
    }

    @Override
    public Future<DescribeStackResourcesResult> describeStackResourcesAsync(final DescribeStackResourcesRequest request, final AsyncHandler<DescribeStackResourcesRequest, DescribeStackResourcesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeStackResourcesResult>(){

            @Override
            public DescribeStackResourcesResult call() throws Exception {
                DescribeStackResourcesResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeStackResources(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync(DescribeStacksRequest request) {
        return this.describeStacksAsync(request, null);
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync(final DescribeStacksRequest request, final AsyncHandler<DescribeStacksRequest, DescribeStacksResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeStacksResult>(){

            @Override
            public DescribeStacksResult call() throws Exception {
                DescribeStacksResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeStacks(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync() {
        return this.describeStacksAsync(new DescribeStacksRequest());
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync(AsyncHandler<DescribeStacksRequest, DescribeStacksResult> asyncHandler) {
        return this.describeStacksAsync(new DescribeStacksRequest(), asyncHandler);
    }

    @Override
    public Future<EstimateTemplateCostResult> estimateTemplateCostAsync(EstimateTemplateCostRequest request) {
        return this.estimateTemplateCostAsync(request, null);
    }

    @Override
    public Future<EstimateTemplateCostResult> estimateTemplateCostAsync(final EstimateTemplateCostRequest request, final AsyncHandler<EstimateTemplateCostRequest, EstimateTemplateCostResult> asyncHandler) {
        return this.executorService.submit(new Callable<EstimateTemplateCostResult>(){

            @Override
            public EstimateTemplateCostResult call() throws Exception {
                EstimateTemplateCostResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.estimateTemplateCost(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EstimateTemplateCostResult> estimateTemplateCostAsync() {
        return this.estimateTemplateCostAsync(new EstimateTemplateCostRequest());
    }

    @Override
    public Future<EstimateTemplateCostResult> estimateTemplateCostAsync(AsyncHandler<EstimateTemplateCostRequest, EstimateTemplateCostResult> asyncHandler) {
        return this.estimateTemplateCostAsync(new EstimateTemplateCostRequest(), asyncHandler);
    }

    @Override
    public Future<ExecuteChangeSetResult> executeChangeSetAsync(ExecuteChangeSetRequest request) {
        return this.executeChangeSetAsync(request, null);
    }

    @Override
    public Future<ExecuteChangeSetResult> executeChangeSetAsync(final ExecuteChangeSetRequest request, final AsyncHandler<ExecuteChangeSetRequest, ExecuteChangeSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<ExecuteChangeSetResult>(){

            @Override
            public ExecuteChangeSetResult call() throws Exception {
                ExecuteChangeSetResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.executeChangeSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStackPolicyResult> getStackPolicyAsync(GetStackPolicyRequest request) {
        return this.getStackPolicyAsync(request, null);
    }

    @Override
    public Future<GetStackPolicyResult> getStackPolicyAsync(final GetStackPolicyRequest request, final AsyncHandler<GetStackPolicyRequest, GetStackPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetStackPolicyResult>(){

            @Override
            public GetStackPolicyResult call() throws Exception {
                GetStackPolicyResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.getStackPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTemplateResult> getTemplateAsync(GetTemplateRequest request) {
        return this.getTemplateAsync(request, null);
    }

    @Override
    public Future<GetTemplateResult> getTemplateAsync(final GetTemplateRequest request, final AsyncHandler<GetTemplateRequest, GetTemplateResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTemplateResult>(){

            @Override
            public GetTemplateResult call() throws Exception {
                GetTemplateResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.getTemplate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTemplateSummaryResult> getTemplateSummaryAsync(GetTemplateSummaryRequest request) {
        return this.getTemplateSummaryAsync(request, null);
    }

    @Override
    public Future<GetTemplateSummaryResult> getTemplateSummaryAsync(final GetTemplateSummaryRequest request, final AsyncHandler<GetTemplateSummaryRequest, GetTemplateSummaryResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTemplateSummaryResult>(){

            @Override
            public GetTemplateSummaryResult call() throws Exception {
                GetTemplateSummaryResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.getTemplateSummary(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTemplateSummaryResult> getTemplateSummaryAsync() {
        return this.getTemplateSummaryAsync(new GetTemplateSummaryRequest());
    }

    @Override
    public Future<GetTemplateSummaryResult> getTemplateSummaryAsync(AsyncHandler<GetTemplateSummaryRequest, GetTemplateSummaryResult> asyncHandler) {
        return this.getTemplateSummaryAsync(new GetTemplateSummaryRequest(), asyncHandler);
    }

    @Override
    public Future<ListChangeSetsResult> listChangeSetsAsync(ListChangeSetsRequest request) {
        return this.listChangeSetsAsync(request, null);
    }

    @Override
    public Future<ListChangeSetsResult> listChangeSetsAsync(final ListChangeSetsRequest request, final AsyncHandler<ListChangeSetsRequest, ListChangeSetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListChangeSetsResult>(){

            @Override
            public ListChangeSetsResult call() throws Exception {
                ListChangeSetsResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.listChangeSets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExportsResult> listExportsAsync(ListExportsRequest request) {
        return this.listExportsAsync(request, null);
    }

    @Override
    public Future<ListExportsResult> listExportsAsync(final ListExportsRequest request, final AsyncHandler<ListExportsRequest, ListExportsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListExportsResult>(){

            @Override
            public ListExportsResult call() throws Exception {
                ListExportsResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.listExports(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListImportsResult> listImportsAsync(ListImportsRequest request) {
        return this.listImportsAsync(request, null);
    }

    @Override
    public Future<ListImportsResult> listImportsAsync(final ListImportsRequest request, final AsyncHandler<ListImportsRequest, ListImportsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListImportsResult>(){

            @Override
            public ListImportsResult call() throws Exception {
                ListImportsResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.listImports(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStackResourcesResult> listStackResourcesAsync(ListStackResourcesRequest request) {
        return this.listStackResourcesAsync(request, null);
    }

    @Override
    public Future<ListStackResourcesResult> listStackResourcesAsync(final ListStackResourcesRequest request, final AsyncHandler<ListStackResourcesRequest, ListStackResourcesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListStackResourcesResult>(){

            @Override
            public ListStackResourcesResult call() throws Exception {
                ListStackResourcesResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.listStackResources(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStacksResult> listStacksAsync(ListStacksRequest request) {
        return this.listStacksAsync(request, null);
    }

    @Override
    public Future<ListStacksResult> listStacksAsync(final ListStacksRequest request, final AsyncHandler<ListStacksRequest, ListStacksResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListStacksResult>(){

            @Override
            public ListStacksResult call() throws Exception {
                ListStacksResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.listStacks(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStacksResult> listStacksAsync() {
        return this.listStacksAsync(new ListStacksRequest());
    }

    @Override
    public Future<ListStacksResult> listStacksAsync(AsyncHandler<ListStacksRequest, ListStacksResult> asyncHandler) {
        return this.listStacksAsync(new ListStacksRequest(), asyncHandler);
    }

    @Override
    public Future<SetStackPolicyResult> setStackPolicyAsync(SetStackPolicyRequest request) {
        return this.setStackPolicyAsync(request, null);
    }

    @Override
    public Future<SetStackPolicyResult> setStackPolicyAsync(final SetStackPolicyRequest request, final AsyncHandler<SetStackPolicyRequest, SetStackPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetStackPolicyResult>(){

            @Override
            public SetStackPolicyResult call() throws Exception {
                SetStackPolicyResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.setStackPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SignalResourceResult> signalResourceAsync(SignalResourceRequest request) {
        return this.signalResourceAsync(request, null);
    }

    @Override
    public Future<SignalResourceResult> signalResourceAsync(final SignalResourceRequest request, final AsyncHandler<SignalResourceRequest, SignalResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<SignalResourceResult>(){

            @Override
            public SignalResourceResult call() throws Exception {
                SignalResourceResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.signalResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateStackResult> updateStackAsync(UpdateStackRequest request) {
        return this.updateStackAsync(request, null);
    }

    @Override
    public Future<UpdateStackResult> updateStackAsync(final UpdateStackRequest request, final AsyncHandler<UpdateStackRequest, UpdateStackResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateStackResult>(){

            @Override
            public UpdateStackResult call() throws Exception {
                UpdateStackResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.updateStack(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ValidateTemplateResult> validateTemplateAsync(ValidateTemplateRequest request) {
        return this.validateTemplateAsync(request, null);
    }

    @Override
    public Future<ValidateTemplateResult> validateTemplateAsync(final ValidateTemplateRequest request, final AsyncHandler<ValidateTemplateRequest, ValidateTemplateResult> asyncHandler) {
        return this.executorService.submit(new Callable<ValidateTemplateResult>(){

            @Override
            public ValidateTemplateResult call() throws Exception {
                ValidateTemplateResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.validateTemplate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

