/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.budgets.model.CalculatedSpend;
import com.amazonaws.services.budgets.model.transform.SpendJsonMarshaller;

public class CalculatedSpendJsonMarshaller {
    private static CalculatedSpendJsonMarshaller instance;

    public void marshall(CalculatedSpend calculatedSpend, StructuredJsonGenerator jsonGenerator) {
        if (calculatedSpend == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (calculatedSpend.getActualSpend() != null) {
                jsonGenerator.writeFieldName("ActualSpend");
                SpendJsonMarshaller.getInstance().marshall(calculatedSpend.getActualSpend(), jsonGenerator);
            }
            if (calculatedSpend.getForecastedSpend() != null) {
                jsonGenerator.writeFieldName("ForecastedSpend");
                SpendJsonMarshaller.getInstance().marshall(calculatedSpend.getForecastedSpend(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CalculatedSpendJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CalculatedSpendJsonMarshaller();
        }
        return instance;
    }
}

