/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationautoscaling.model.Alarm;
import com.amazonaws.services.applicationautoscaling.model.ScalingPolicy;
import com.amazonaws.services.applicationautoscaling.model.transform.AlarmJsonMarshaller;
import com.amazonaws.services.applicationautoscaling.model.transform.StepScalingPolicyConfigurationJsonMarshaller;
import java.util.List;

public class ScalingPolicyJsonMarshaller {
    private static ScalingPolicyJsonMarshaller instance;

    public void marshall(ScalingPolicy scalingPolicy, StructuredJsonGenerator jsonGenerator) {
        if (scalingPolicy == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Alarm> alarmsList;
            jsonGenerator.writeStartObject();
            if (scalingPolicy.getPolicyARN() != null) {
                jsonGenerator.writeFieldName("PolicyARN").writeValue(scalingPolicy.getPolicyARN());
            }
            if (scalingPolicy.getPolicyName() != null) {
                jsonGenerator.writeFieldName("PolicyName").writeValue(scalingPolicy.getPolicyName());
            }
            if (scalingPolicy.getServiceNamespace() != null) {
                jsonGenerator.writeFieldName("ServiceNamespace").writeValue(scalingPolicy.getServiceNamespace());
            }
            if (scalingPolicy.getResourceId() != null) {
                jsonGenerator.writeFieldName("ResourceId").writeValue(scalingPolicy.getResourceId());
            }
            if (scalingPolicy.getScalableDimension() != null) {
                jsonGenerator.writeFieldName("ScalableDimension").writeValue(scalingPolicy.getScalableDimension());
            }
            if (scalingPolicy.getPolicyType() != null) {
                jsonGenerator.writeFieldName("PolicyType").writeValue(scalingPolicy.getPolicyType());
            }
            if (scalingPolicy.getStepScalingPolicyConfiguration() != null) {
                jsonGenerator.writeFieldName("StepScalingPolicyConfiguration");
                StepScalingPolicyConfigurationJsonMarshaller.getInstance().marshall(scalingPolicy.getStepScalingPolicyConfiguration(), jsonGenerator);
            }
            if ((alarmsList = scalingPolicy.getAlarms()) != null) {
                jsonGenerator.writeFieldName("Alarms");
                jsonGenerator.writeStartArray();
                for (Alarm alarmsListValue : alarmsList) {
                    if (alarmsListValue == null) continue;
                    AlarmJsonMarshaller.getInstance().marshall(alarmsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (scalingPolicy.getCreationTime() != null) {
                jsonGenerator.writeFieldName("CreationTime").writeValue(scalingPolicy.getCreationTime());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ScalingPolicyJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ScalingPolicyJsonMarshaller();
        }
        return instance;
    }
}

