/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetDocumentationPartRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetDocumentationPartRequestMarshaller
implements Marshaller<Request<GetDocumentationPartRequest>, GetDocumentationPartRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetDocumentationPartRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetDocumentationPartRequest> marshall(GetDocumentationPartRequest getDocumentationPartRequest) {
        if (getDocumentationPartRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDocumentationPartRequest> request = new DefaultRequest<GetDocumentationPartRequest>(getDocumentationPartRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/documentation/parts/{part_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getDocumentationPartRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getDocumentationPartRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{part_id}", getDocumentationPartRequest.getDocumentationPartId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getDocumentationPartRequest.getDocumentationPartId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

