/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.route53domains.model.Nameserver;

public class NameserverJsonMarshaller {
    private static NameserverJsonMarshaller instance;

    public void marshall(Nameserver nameserver, StructuredJsonGenerator jsonGenerator) {
        if (nameserver == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList glueIpsList;
            jsonGenerator.writeStartObject();
            if (nameserver.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(nameserver.getName());
            }
            if (!(glueIpsList = (SdkInternalList)nameserver.getGlueIps()).isEmpty() || !glueIpsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("GlueIps");
                jsonGenerator.writeStartArray();
                for (String glueIpsListValue : glueIpsList) {
                    if (glueIpsListValue == null) continue;
                    jsonGenerator.writeValue(glueIpsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static NameserverJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new NameserverJsonMarshaller();
        }
        return instance;
    }
}

