/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.elastictranscoder.model.CreateJobOutput;
import com.amazonaws.services.elastictranscoder.model.CreateJobPlaylist;
import com.amazonaws.services.elastictranscoder.model.JobInput;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CreateJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String pipelineId;
    private JobInput input;
    private SdkInternalList<JobInput> inputs;
    private CreateJobOutput output;
    private SdkInternalList<CreateJobOutput> outputs;
    private String outputKeyPrefix;
    private SdkInternalList<CreateJobPlaylist> playlists;
    private SdkInternalMap<String, String> userMetadata;

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public CreateJobRequest withPipelineId(String pipelineId) {
        this.setPipelineId(pipelineId);
        return this;
    }

    public void setInput(JobInput input) {
        this.input = input;
    }

    public JobInput getInput() {
        return this.input;
    }

    public CreateJobRequest withInput(JobInput input) {
        this.setInput(input);
        return this;
    }

    public List<JobInput> getInputs() {
        if (this.inputs == null) {
            this.inputs = new SdkInternalList();
        }
        return this.inputs;
    }

    public void setInputs(Collection<JobInput> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new SdkInternalList<JobInput>(inputs);
    }

    public CreateJobRequest withInputs(JobInput ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new SdkInternalList<JobInput>(inputs.length));
        }
        for (JobInput ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public CreateJobRequest withInputs(Collection<JobInput> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public void setOutput(CreateJobOutput output) {
        this.output = output;
    }

    public CreateJobOutput getOutput() {
        return this.output;
    }

    public CreateJobRequest withOutput(CreateJobOutput output) {
        this.setOutput(output);
        return this;
    }

    public List<CreateJobOutput> getOutputs() {
        if (this.outputs == null) {
            this.outputs = new SdkInternalList();
        }
        return this.outputs;
    }

    public void setOutputs(Collection<CreateJobOutput> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new SdkInternalList<CreateJobOutput>(outputs);
    }

    public CreateJobRequest withOutputs(CreateJobOutput ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new SdkInternalList<CreateJobOutput>(outputs.length));
        }
        for (CreateJobOutput ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public CreateJobRequest withOutputs(Collection<CreateJobOutput> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public void setOutputKeyPrefix(String outputKeyPrefix) {
        this.outputKeyPrefix = outputKeyPrefix;
    }

    public String getOutputKeyPrefix() {
        return this.outputKeyPrefix;
    }

    public CreateJobRequest withOutputKeyPrefix(String outputKeyPrefix) {
        this.setOutputKeyPrefix(outputKeyPrefix);
        return this;
    }

    public List<CreateJobPlaylist> getPlaylists() {
        if (this.playlists == null) {
            this.playlists = new SdkInternalList();
        }
        return this.playlists;
    }

    public void setPlaylists(Collection<CreateJobPlaylist> playlists) {
        if (playlists == null) {
            this.playlists = null;
            return;
        }
        this.playlists = new SdkInternalList<CreateJobPlaylist>(playlists);
    }

    public CreateJobRequest withPlaylists(CreateJobPlaylist ... playlists) {
        if (this.playlists == null) {
            this.setPlaylists(new SdkInternalList<CreateJobPlaylist>(playlists.length));
        }
        for (CreateJobPlaylist ele : playlists) {
            this.playlists.add(ele);
        }
        return this;
    }

    public CreateJobRequest withPlaylists(Collection<CreateJobPlaylist> playlists) {
        this.setPlaylists(playlists);
        return this;
    }

    public Map<String, String> getUserMetadata() {
        if (this.userMetadata == null) {
            this.userMetadata = new SdkInternalMap();
        }
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata == null ? null : new SdkInternalMap<String, String>(userMetadata);
    }

    public CreateJobRequest withUserMetadata(Map<String, String> userMetadata) {
        this.setUserMetadata(userMetadata);
        return this;
    }

    public CreateJobRequest addUserMetadataEntry(String key, String value) {
        if (null == this.userMetadata) {
            this.userMetadata = new SdkInternalMap();
        }
        if (this.userMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.userMetadata.put(key, value);
        return this;
    }

    public CreateJobRequest clearUserMetadataEntries() {
        this.userMetadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: " + this.getPipelineId() + ",");
        }
        if (this.getInput() != null) {
            sb.append("Input: " + this.getInput() + ",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: " + this.getInputs() + ",");
        }
        if (this.getOutput() != null) {
            sb.append("Output: " + this.getOutput() + ",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: " + this.getOutputs() + ",");
        }
        if (this.getOutputKeyPrefix() != null) {
            sb.append("OutputKeyPrefix: " + this.getOutputKeyPrefix() + ",");
        }
        if (this.getPlaylists() != null) {
            sb.append("Playlists: " + this.getPlaylists() + ",");
        }
        if (this.getUserMetadata() != null) {
            sb.append("UserMetadata: " + this.getUserMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)obj;
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getInput() == null ^ this.getInput() == null) {
            return false;
        }
        if (other.getInput() != null && !other.getInput().equals(this.getInput())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getOutput() == null ^ this.getOutput() == null) {
            return false;
        }
        if (other.getOutput() != null && !other.getOutput().equals(this.getOutput())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getOutputKeyPrefix() == null ^ this.getOutputKeyPrefix() == null) {
            return false;
        }
        if (other.getOutputKeyPrefix() != null && !other.getOutputKeyPrefix().equals(this.getOutputKeyPrefix())) {
            return false;
        }
        if (other.getPlaylists() == null ^ this.getPlaylists() == null) {
            return false;
        }
        if (other.getPlaylists() != null && !other.getPlaylists().equals(this.getPlaylists())) {
            return false;
        }
        if (other.getUserMetadata() == null ^ this.getUserMetadata() == null) {
            return false;
        }
        return other.getUserMetadata() == null || other.getUserMetadata().equals(this.getUserMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getInput() == null ? 0 : this.getInput().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getOutput() == null ? 0 : this.getOutput().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getOutputKeyPrefix() == null ? 0 : this.getOutputKeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getPlaylists() == null ? 0 : this.getPlaylists().hashCode());
        hashCode = 31 * hashCode + (this.getUserMetadata() == null ? 0 : this.getUserMetadata().hashCode());
        return hashCode;
    }

    @Override
    public CreateJobRequest clone() {
        return (CreateJobRequest)super.clone();
    }
}

