/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationautoscaling.model.DescribeScalingPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DescribeScalingPoliciesRequestMarshaller
implements Marshaller<Request<DescribeScalingPoliciesRequest>, DescribeScalingPoliciesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeScalingPoliciesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeScalingPoliciesRequest> marshall(DescribeScalingPoliciesRequest describeScalingPoliciesRequest) {
        if (describeScalingPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeScalingPoliciesRequest> request = new DefaultRequest<DescribeScalingPoliciesRequest>(describeScalingPoliciesRequest, "AWSApplicationAutoScaling");
        request.addHeader("X-Amz-Target", "AnyScaleFrontendService.DescribeScalingPolicies");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> policyNamesList = describeScalingPoliciesRequest.getPolicyNames();
            if (policyNamesList != null) {
                jsonGenerator.writeFieldName("PolicyNames");
                jsonGenerator.writeStartArray();
                for (String policyNamesListValue : policyNamesList) {
                    if (policyNamesListValue == null) continue;
                    jsonGenerator.writeValue(policyNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeScalingPoliciesRequest.getServiceNamespace() != null) {
                jsonGenerator.writeFieldName("ServiceNamespace").writeValue(describeScalingPoliciesRequest.getServiceNamespace());
            }
            if (describeScalingPoliciesRequest.getResourceId() != null) {
                jsonGenerator.writeFieldName("ResourceId").writeValue(describeScalingPoliciesRequest.getResourceId());
            }
            if (describeScalingPoliciesRequest.getScalableDimension() != null) {
                jsonGenerator.writeFieldName("ScalableDimension").writeValue(describeScalingPoliciesRequest.getScalableDimension());
            }
            if (describeScalingPoliciesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(describeScalingPoliciesRequest.getMaxResults());
            }
            if (describeScalingPoliciesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeScalingPoliciesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

