/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kms.model.GenerateRandomRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GenerateRandomRequestMarshaller
implements Marshaller<Request<GenerateRandomRequest>, GenerateRandomRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GenerateRandomRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GenerateRandomRequest> marshall(GenerateRandomRequest generateRandomRequest) {
        if (generateRandomRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GenerateRandomRequest> request = new DefaultRequest<GenerateRandomRequest>(generateRandomRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.GenerateRandom");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (generateRandomRequest.getNumberOfBytes() != null) {
                jsonGenerator.writeFieldName("NumberOfBytes").writeValue(generateRandomRequest.getNumberOfBytes());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

