/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.CreateVaultRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class CreateVaultRequestMarshaller
implements Marshaller<Request<CreateVaultRequest>, CreateVaultRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateVaultRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateVaultRequest> marshall(CreateVaultRequest createVaultRequest) {
        if (createVaultRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateVaultRequest> request = new DefaultRequest<CreateVaultRequest>(createVaultRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}";
        uriResourcePath = uriResourcePath.replace("{accountId}", createVaultRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(createVaultRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", createVaultRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(createVaultRequest.getVaultName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

