/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ActiveInstance;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeSpotFleetInstancesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String spotFleetRequestId;
    private SdkInternalList<ActiveInstance> activeInstances;
    private String nextToken;

    public void setSpotFleetRequestId(String spotFleetRequestId) {
        this.spotFleetRequestId = spotFleetRequestId;
    }

    public String getSpotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public DescribeSpotFleetInstancesResult withSpotFleetRequestId(String spotFleetRequestId) {
        this.setSpotFleetRequestId(spotFleetRequestId);
        return this;
    }

    public List<ActiveInstance> getActiveInstances() {
        if (this.activeInstances == null) {
            this.activeInstances = new SdkInternalList();
        }
        return this.activeInstances;
    }

    public void setActiveInstances(Collection<ActiveInstance> activeInstances) {
        if (activeInstances == null) {
            this.activeInstances = null;
            return;
        }
        this.activeInstances = new SdkInternalList<ActiveInstance>(activeInstances);
    }

    public DescribeSpotFleetInstancesResult withActiveInstances(ActiveInstance ... activeInstances) {
        if (this.activeInstances == null) {
            this.setActiveInstances(new SdkInternalList<ActiveInstance>(activeInstances.length));
        }
        for (ActiveInstance ele : activeInstances) {
            this.activeInstances.add(ele);
        }
        return this;
    }

    public DescribeSpotFleetInstancesResult withActiveInstances(Collection<ActiveInstance> activeInstances) {
        this.setActiveInstances(activeInstances);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeSpotFleetInstancesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSpotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: " + this.getSpotFleetRequestId() + ",");
        }
        if (this.getActiveInstances() != null) {
            sb.append("ActiveInstances: " + this.getActiveInstances() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetInstancesResult)) {
            return false;
        }
        DescribeSpotFleetInstancesResult other = (DescribeSpotFleetInstancesResult)obj;
        if (other.getSpotFleetRequestId() == null ^ this.getSpotFleetRequestId() == null) {
            return false;
        }
        if (other.getSpotFleetRequestId() != null && !other.getSpotFleetRequestId().equals(this.getSpotFleetRequestId())) {
            return false;
        }
        if (other.getActiveInstances() == null ^ this.getActiveInstances() == null) {
            return false;
        }
        if (other.getActiveInstances() != null && !other.getActiveInstances().equals(this.getActiveInstances())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSpotFleetRequestId() == null ? 0 : this.getSpotFleetRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getActiveInstances() == null ? 0 : this.getActiveInstances().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeSpotFleetInstancesResult clone() {
        try {
            return (DescribeSpotFleetInstancesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

