/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationBatchRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationBatchRequestEntry;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateAssociationBatchRequestEntryJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateAssociationBatchRequestMarshaller
implements Marshaller<Request<CreateAssociationBatchRequest>, CreateAssociationBatchRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateAssociationBatchRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateAssociationBatchRequest> marshall(CreateAssociationBatchRequest createAssociationBatchRequest) {
        if (createAssociationBatchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateAssociationBatchRequest> request = new DefaultRequest<CreateAssociationBatchRequest>(createAssociationBatchRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.CreateAssociationBatch");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList entriesList = (SdkInternalList)createAssociationBatchRequest.getEntries();
            if (!entriesList.isEmpty() || !entriesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Entries");
                jsonGenerator.writeStartArray();
                for (CreateAssociationBatchRequestEntry entriesListValue : entriesList) {
                    if (entriesListValue == null) continue;
                    CreateAssociationBatchRequestEntryJsonMarshaller.getInstance().marshall(entriesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

