/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.TopicRule;
import com.amazonaws.services.iot.model.transform.ActionJsonMarshaller;
import java.util.List;

public class TopicRuleJsonMarshaller {
    private static TopicRuleJsonMarshaller instance;

    public void marshall(TopicRule topicRule, StructuredJsonGenerator jsonGenerator) {
        if (topicRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Action> actionsList;
            jsonGenerator.writeStartObject();
            if (topicRule.getRuleName() != null) {
                jsonGenerator.writeFieldName("ruleName").writeValue(topicRule.getRuleName());
            }
            if (topicRule.getSql() != null) {
                jsonGenerator.writeFieldName("sql").writeValue(topicRule.getSql());
            }
            if (topicRule.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(topicRule.getDescription());
            }
            if (topicRule.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(topicRule.getCreatedAt());
            }
            if ((actionsList = topicRule.getActions()) != null) {
                jsonGenerator.writeFieldName("actions");
                jsonGenerator.writeStartArray();
                for (Action actionsListValue : actionsList) {
                    if (actionsListValue == null) continue;
                    ActionJsonMarshaller.getInstance().marshall(actionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (topicRule.getRuleDisabled() != null) {
                jsonGenerator.writeFieldName("ruleDisabled").writeValue(topicRule.getRuleDisabled());
            }
            if (topicRule.getAwsIotSqlVersion() != null) {
                jsonGenerator.writeFieldName("awsIotSqlVersion").writeValue(topicRule.getAwsIotSqlVersion());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TopicRuleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TopicRuleJsonMarshaller();
        }
        return instance;
    }
}

