/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;

public class UploadArchiveRequestMarshaller
implements Marshaller<Request<UploadArchiveRequest>, UploadArchiveRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UploadArchiveRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UploadArchiveRequest> marshall(UploadArchiveRequest uploadArchiveRequest) {
        if (uploadArchiveRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UploadArchiveRequest> request = new DefaultRequest<UploadArchiveRequest>(uploadArchiveRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.POST);
        if (uploadArchiveRequest.getArchiveDescription() != null) {
            request.addHeader("x-amz-archive-description", StringUtils.fromString(uploadArchiveRequest.getArchiveDescription()));
        }
        if (uploadArchiveRequest.getChecksum() != null) {
            request.addHeader("x-amz-sha256-tree-hash", StringUtils.fromString(uploadArchiveRequest.getChecksum()));
        }
        if (uploadArchiveRequest.getContentLength() != null) {
            request.addHeader("Content-Length", StringUtils.fromLong(uploadArchiveRequest.getContentLength()));
        }
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/archives";
        uriResourcePath = uriResourcePath.replace("{vaultName}", uploadArchiveRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(uploadArchiveRequest.getVaultName()), false) : "");
        uriResourcePath = uriResourcePath.replace("{accountId}", uploadArchiveRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(uploadArchiveRequest.getAccountId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(uploadArchiveRequest.getBody());
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

