/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.DeploymentInfo;
import com.amazonaws.services.codedeploy.model.transform.AutoRollbackConfigurationJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.DeploymentOverviewJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.ErrorInformationJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.RevisionLocationJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.RollbackInfoJsonMarshaller;

public class DeploymentInfoJsonMarshaller {
    private static DeploymentInfoJsonMarshaller instance;

    public void marshall(DeploymentInfo deploymentInfo, StructuredJsonGenerator jsonGenerator) {
        if (deploymentInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (deploymentInfo.getApplicationName() != null) {
                jsonGenerator.writeFieldName("applicationName").writeValue(deploymentInfo.getApplicationName());
            }
            if (deploymentInfo.getDeploymentGroupName() != null) {
                jsonGenerator.writeFieldName("deploymentGroupName").writeValue(deploymentInfo.getDeploymentGroupName());
            }
            if (deploymentInfo.getDeploymentConfigName() != null) {
                jsonGenerator.writeFieldName("deploymentConfigName").writeValue(deploymentInfo.getDeploymentConfigName());
            }
            if (deploymentInfo.getDeploymentId() != null) {
                jsonGenerator.writeFieldName("deploymentId").writeValue(deploymentInfo.getDeploymentId());
            }
            if (deploymentInfo.getRevision() != null) {
                jsonGenerator.writeFieldName("revision");
                RevisionLocationJsonMarshaller.getInstance().marshall(deploymentInfo.getRevision(), jsonGenerator);
            }
            if (deploymentInfo.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(deploymentInfo.getStatus());
            }
            if (deploymentInfo.getErrorInformation() != null) {
                jsonGenerator.writeFieldName("errorInformation");
                ErrorInformationJsonMarshaller.getInstance().marshall(deploymentInfo.getErrorInformation(), jsonGenerator);
            }
            if (deploymentInfo.getCreateTime() != null) {
                jsonGenerator.writeFieldName("createTime").writeValue(deploymentInfo.getCreateTime());
            }
            if (deploymentInfo.getStartTime() != null) {
                jsonGenerator.writeFieldName("startTime").writeValue(deploymentInfo.getStartTime());
            }
            if (deploymentInfo.getCompleteTime() != null) {
                jsonGenerator.writeFieldName("completeTime").writeValue(deploymentInfo.getCompleteTime());
            }
            if (deploymentInfo.getDeploymentOverview() != null) {
                jsonGenerator.writeFieldName("deploymentOverview");
                DeploymentOverviewJsonMarshaller.getInstance().marshall(deploymentInfo.getDeploymentOverview(), jsonGenerator);
            }
            if (deploymentInfo.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(deploymentInfo.getDescription());
            }
            if (deploymentInfo.getCreator() != null) {
                jsonGenerator.writeFieldName("creator").writeValue(deploymentInfo.getCreator());
            }
            if (deploymentInfo.getIgnoreApplicationStopFailures() != null) {
                jsonGenerator.writeFieldName("ignoreApplicationStopFailures").writeValue(deploymentInfo.getIgnoreApplicationStopFailures());
            }
            if (deploymentInfo.getAutoRollbackConfiguration() != null) {
                jsonGenerator.writeFieldName("autoRollbackConfiguration");
                AutoRollbackConfigurationJsonMarshaller.getInstance().marshall(deploymentInfo.getAutoRollbackConfiguration(), jsonGenerator);
            }
            if (deploymentInfo.getUpdateOutdatedInstancesOnly() != null) {
                jsonGenerator.writeFieldName("updateOutdatedInstancesOnly").writeValue(deploymentInfo.getUpdateOutdatedInstancesOnly());
            }
            if (deploymentInfo.getRollbackInfo() != null) {
                jsonGenerator.writeFieldName("rollbackInfo");
                RollbackInfoJsonMarshaller.getInstance().marshall(deploymentInfo.getRollbackInfo(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeploymentInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentInfoJsonMarshaller();
        }
        return instance;
    }
}

