/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class GetAttributesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainName;
    private String itemName;
    private SdkInternalList<String> attributeNames;
    private Boolean consistentRead;

    public GetAttributesRequest() {
    }

    public GetAttributesRequest(String domainName, String itemName) {
        this.setDomainName(domainName);
        this.setItemName(itemName);
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public GetAttributesRequest withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public GetAttributesRequest withItemName(String itemName) {
        this.setItemName(itemName);
        return this;
    }

    public List<String> getAttributeNames() {
        if (this.attributeNames == null) {
            this.attributeNames = new SdkInternalList();
        }
        return this.attributeNames;
    }

    public void setAttributeNames(Collection<String> attributeNames) {
        if (attributeNames == null) {
            this.attributeNames = null;
            return;
        }
        this.attributeNames = new SdkInternalList<String>(attributeNames);
    }

    public GetAttributesRequest withAttributeNames(String ... attributeNames) {
        if (this.attributeNames == null) {
            this.setAttributeNames(new SdkInternalList<String>(attributeNames.length));
        }
        for (String ele : attributeNames) {
            this.attributeNames.add(ele);
        }
        return this;
    }

    public GetAttributesRequest withAttributeNames(Collection<String> attributeNames) {
        this.setAttributeNames(attributeNames);
        return this;
    }

    public void setConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
    }

    public Boolean getConsistentRead() {
        return this.consistentRead;
    }

    public GetAttributesRequest withConsistentRead(Boolean consistentRead) {
        this.setConsistentRead(consistentRead);
        return this;
    }

    public Boolean isConsistentRead() {
        return this.consistentRead;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: " + this.getDomainName() + ",");
        }
        if (this.getItemName() != null) {
            sb.append("ItemName: " + this.getItemName() + ",");
        }
        if (this.getAttributeNames() != null) {
            sb.append("AttributeNames: " + this.getAttributeNames() + ",");
        }
        if (this.getConsistentRead() != null) {
            sb.append("ConsistentRead: " + this.getConsistentRead());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAttributesRequest)) {
            return false;
        }
        GetAttributesRequest other = (GetAttributesRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getItemName() == null ^ this.getItemName() == null) {
            return false;
        }
        if (other.getItemName() != null && !other.getItemName().equals(this.getItemName())) {
            return false;
        }
        if (other.getAttributeNames() == null ^ this.getAttributeNames() == null) {
            return false;
        }
        if (other.getAttributeNames() != null && !other.getAttributeNames().equals(this.getAttributeNames())) {
            return false;
        }
        if (other.getConsistentRead() == null ^ this.getConsistentRead() == null) {
            return false;
        }
        return other.getConsistentRead() == null || other.getConsistentRead().equals(this.getConsistentRead());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getItemName() == null ? 0 : this.getItemName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeNames() == null ? 0 : this.getAttributeNames().hashCode());
        hashCode = 31 * hashCode + (this.getConsistentRead() == null ? 0 : this.getConsistentRead().hashCode());
        return hashCode;
    }

    @Override
    public GetAttributesRequest clone() {
        return (GetAttributesRequest)super.clone();
    }
}

