/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.CreateProvisioningArtifactRequest;
import com.amazonaws.services.servicecatalog.model.transform.ProvisioningArtifactPropertiesJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import java.io.ByteArrayInputStream;

public class CreateProvisioningArtifactRequestMarshaller
implements Marshaller<Request<CreateProvisioningArtifactRequest>, CreateProvisioningArtifactRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateProvisioningArtifactRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateProvisioningArtifactRequest> marshall(CreateProvisioningArtifactRequest createProvisioningArtifactRequest) {
        if (createProvisioningArtifactRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateProvisioningArtifactRequest> request = new DefaultRequest<CreateProvisioningArtifactRequest>(createProvisioningArtifactRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.CreateProvisioningArtifact");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createProvisioningArtifactRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(createProvisioningArtifactRequest.getAcceptLanguage());
            }
            if (createProvisioningArtifactRequest.getProductId() != null) {
                jsonGenerator.writeFieldName("ProductId").writeValue(createProvisioningArtifactRequest.getProductId());
            }
            if (createProvisioningArtifactRequest.getParameters() != null) {
                jsonGenerator.writeFieldName("Parameters");
                ProvisioningArtifactPropertiesJsonMarshaller.getInstance().marshall(createProvisioningArtifactRequest.getParameters(), jsonGenerator);
            }
            jsonGenerator.writeFieldName("IdempotencyToken").writeValue(IdempotentUtils.resolveString(createProvisioningArtifactRequest.getIdempotencyToken()));
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

