/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;

public class DeleteStreamingDistributionRequestMarshaller
implements Marshaller<Request<DeleteStreamingDistributionRequest>, DeleteStreamingDistributionRequest> {
    @Override
    public Request<DeleteStreamingDistributionRequest> marshall(DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) {
        if (deleteStreamingDistributionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteStreamingDistributionRequest> request = new DefaultRequest<DeleteStreamingDistributionRequest>(deleteStreamingDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteStreamingDistributionRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString(deleteStreamingDistributionRequest.getIfMatch()));
        }
        String uriResourcePath = "/2016-09-29/streaming-distribution/{Id}";
        uriResourcePath = uriResourcePath.replace("{Id}", deleteStreamingDistributionRequest.getId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteStreamingDistributionRequest.getId()), false) : "");
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

