/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.ListPolicyPrincipalsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListPolicyPrincipalsRequestMarshaller
implements Marshaller<Request<ListPolicyPrincipalsRequest>, ListPolicyPrincipalsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListPolicyPrincipalsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListPolicyPrincipalsRequest> marshall(ListPolicyPrincipalsRequest listPolicyPrincipalsRequest) {
        if (listPolicyPrincipalsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListPolicyPrincipalsRequest> request = new DefaultRequest<ListPolicyPrincipalsRequest>(listPolicyPrincipalsRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        if (listPolicyPrincipalsRequest.getPolicyName() != null) {
            request.addHeader("x-amzn-iot-policy", StringUtils.fromString(listPolicyPrincipalsRequest.getPolicyName()));
        }
        String uriResourcePath = "/policy-principals";
        request.setResourcePath(uriResourcePath);
        if (listPolicyPrincipalsRequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString(listPolicyPrincipalsRequest.getMarker()));
        }
        if (listPolicyPrincipalsRequest.getPageSize() != null) {
            request.addParameter("pageSize", StringUtils.fromInteger(listPolicyPrincipalsRequest.getPageSize()));
        }
        if (listPolicyPrincipalsRequest.getAscendingOrder() != null) {
            request.addParameter("isAscendingOrder", StringUtils.fromBoolean(listPolicyPrincipalsRequest.getAscendingOrder()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

