/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.LaunchPermission;
import com.amazonaws.services.ec2.model.LaunchPermissionModifications;
import com.amazonaws.services.ec2.model.ModifyImageAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyImageAttributeRequestMarshaller
implements Marshaller<Request<ModifyImageAttributeRequest>, ModifyImageAttributeRequest> {
    @Override
    public Request<ModifyImageAttributeRequest> marshall(ModifyImageAttributeRequest modifyImageAttributeRequest) {
        LaunchPermissionModifications launchPermission;
        SdkInternalList modifyImageAttributeRequestProductCodesList;
        SdkInternalList modifyImageAttributeRequestUserGroupsList;
        SdkInternalList modifyImageAttributeRequestUserIdsList;
        if (modifyImageAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyImageAttributeRequest> request = new DefaultRequest<ModifyImageAttributeRequest>(modifyImageAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyImageAttribute");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyImageAttributeRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString(modifyImageAttributeRequest.getImageId()));
        }
        if (modifyImageAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString(modifyImageAttributeRequest.getAttribute()));
        }
        if (modifyImageAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString(modifyImageAttributeRequest.getOperationType()));
        }
        if (!(modifyImageAttributeRequestUserIdsList = (SdkInternalList)modifyImageAttributeRequest.getUserIds()).isEmpty() || !modifyImageAttributeRequestUserIdsList.isAutoConstruct()) {
            int userIdsListIndex = 1;
            for (Object modifyImageAttributeRequestUserIdsListValue : modifyImageAttributeRequestUserIdsList) {
                if (modifyImageAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString((String)modifyImageAttributeRequestUserIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        if (!(modifyImageAttributeRequestUserGroupsList = (SdkInternalList)modifyImageAttributeRequest.getUserGroups()).isEmpty() || !modifyImageAttributeRequestUserGroupsList.isAutoConstruct()) {
            int userGroupsListIndex = 1;
            for (Object modifyImageAttributeRequestUserGroupsListValue : modifyImageAttributeRequestUserGroupsList) {
                if (modifyImageAttributeRequestUserGroupsListValue != null) {
                    request.addParameter("UserGroup." + userGroupsListIndex, StringUtils.fromString((String)modifyImageAttributeRequestUserGroupsListValue));
                }
                ++userGroupsListIndex;
            }
        }
        if (!(modifyImageAttributeRequestProductCodesList = (SdkInternalList)modifyImageAttributeRequest.getProductCodes()).isEmpty() || !modifyImageAttributeRequestProductCodesList.isAutoConstruct()) {
            int productCodesListIndex = 1;
            for (String modifyImageAttributeRequestProductCodesListValue : modifyImageAttributeRequestProductCodesList) {
                if (modifyImageAttributeRequestProductCodesListValue != null) {
                    request.addParameter("ProductCode." + productCodesListIndex, StringUtils.fromString(modifyImageAttributeRequestProductCodesListValue));
                }
                ++productCodesListIndex;
            }
        }
        if (modifyImageAttributeRequest.getValue() != null) {
            request.addParameter("Value", StringUtils.fromString(modifyImageAttributeRequest.getValue()));
        }
        if ((launchPermission = modifyImageAttributeRequest.getLaunchPermission()) != null) {
            SdkInternalList launchPermissionModificationsRemoveList;
            SdkInternalList launchPermissionModificationsAddList = (SdkInternalList)launchPermission.getAdd();
            if (!launchPermissionModificationsAddList.isEmpty() || !launchPermissionModificationsAddList.isAutoConstruct()) {
                int addListIndex = 1;
                for (LaunchPermission launchPermissionModificationsAddListValue : launchPermissionModificationsAddList) {
                    if (launchPermissionModificationsAddListValue.getUserId() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".UserId", StringUtils.fromString(launchPermissionModificationsAddListValue.getUserId()));
                    }
                    if (launchPermissionModificationsAddListValue.getGroup() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".Group", StringUtils.fromString(launchPermissionModificationsAddListValue.getGroup()));
                    }
                    ++addListIndex;
                }
            }
            if (!(launchPermissionModificationsRemoveList = (SdkInternalList)launchPermission.getRemove()).isEmpty() || !launchPermissionModificationsRemoveList.isAutoConstruct()) {
                int removeListIndex = 1;
                for (LaunchPermission launchPermissionModificationsRemoveListValue : launchPermissionModificationsRemoveList) {
                    if (launchPermissionModificationsRemoveListValue.getUserId() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString(launchPermissionModificationsRemoveListValue.getUserId()));
                    }
                    if (launchPermissionModificationsRemoveListValue.getGroup() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".Group", StringUtils.fromString(launchPermissionModificationsRemoveListValue.getGroup()));
                    }
                    ++removeListIndex;
                }
            }
        }
        if (modifyImageAttributeRequest.getDescription() != null) {
            request.addParameter("Description.Value", StringUtils.fromString(modifyImageAttributeRequest.getDescription()));
        }
        return request;
    }
}

