/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CreateVpcRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateVpcRequestMarshaller
implements Marshaller<Request<CreateVpcRequest>, CreateVpcRequest> {
    @Override
    public Request<CreateVpcRequest> marshall(CreateVpcRequest createVpcRequest) {
        if (createVpcRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateVpcRequest> request = new DefaultRequest<CreateVpcRequest>(createVpcRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVpc");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcRequest.getCidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString(createVpcRequest.getCidrBlock()));
        }
        if (createVpcRequest.getInstanceTenancy() != null) {
            request.addParameter("InstanceTenancy", StringUtils.fromString(createVpcRequest.getInstanceTenancy()));
        }
        return request;
    }
}

