/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.Rule;
import com.amazonaws.services.devicefarm.model.UpdateDevicePoolRequest;
import com.amazonaws.services.devicefarm.model.transform.RuleJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class UpdateDevicePoolRequestMarshaller
implements Marshaller<Request<UpdateDevicePoolRequest>, UpdateDevicePoolRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateDevicePoolRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateDevicePoolRequest> marshall(UpdateDevicePoolRequest updateDevicePoolRequest) {
        if (updateDevicePoolRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateDevicePoolRequest> request = new DefaultRequest<UpdateDevicePoolRequest>(updateDevicePoolRequest, "AWSDeviceFarm");
        request.addHeader("X-Amz-Target", "DeviceFarm_20150623.UpdateDevicePool");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Rule> rulesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateDevicePoolRequest.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(updateDevicePoolRequest.getArn());
            }
            if (updateDevicePoolRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(updateDevicePoolRequest.getName());
            }
            if (updateDevicePoolRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(updateDevicePoolRequest.getDescription());
            }
            if ((rulesList = updateDevicePoolRequest.getRules()) != null) {
                jsonGenerator.writeFieldName("rules");
                jsonGenerator.writeStartArray();
                for (Rule rulesListValue : rulesList) {
                    if (rulesListValue == null) continue;
                    RuleJsonMarshaller.getInstance().marshall(rulesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

