/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.ComplianceSummary;
import com.amazonaws.services.config.model.transform.ComplianceContributorCountJsonMarshaller;

public class ComplianceSummaryJsonMarshaller {
    private static ComplianceSummaryJsonMarshaller instance;

    public void marshall(ComplianceSummary complianceSummary, StructuredJsonGenerator jsonGenerator) {
        if (complianceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (complianceSummary.getCompliantResourceCount() != null) {
                jsonGenerator.writeFieldName("CompliantResourceCount");
                ComplianceContributorCountJsonMarshaller.getInstance().marshall(complianceSummary.getCompliantResourceCount(), jsonGenerator);
            }
            if (complianceSummary.getNonCompliantResourceCount() != null) {
                jsonGenerator.writeFieldName("NonCompliantResourceCount");
                ComplianceContributorCountJsonMarshaller.getInstance().marshall(complianceSummary.getNonCompliantResourceCount(), jsonGenerator);
            }
            if (complianceSummary.getComplianceSummaryTimestamp() != null) {
                jsonGenerator.writeFieldName("ComplianceSummaryTimestamp").writeValue(complianceSummary.getComplianceSummaryTimestamp());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ComplianceSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ComplianceSummaryJsonMarshaller();
        }
        return instance;
    }
}

