/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.Aliases;
import com.amazonaws.services.cloudfront.model.AllowedMethods;
import com.amazonaws.services.cloudfront.model.CacheBehavior;
import com.amazonaws.services.cloudfront.model.CacheBehaviors;
import com.amazonaws.services.cloudfront.model.CachedMethods;
import com.amazonaws.services.cloudfront.model.CookieNames;
import com.amazonaws.services.cloudfront.model.CookiePreference;
import com.amazonaws.services.cloudfront.model.CreateDistributionRequest;
import com.amazonaws.services.cloudfront.model.CustomErrorResponse;
import com.amazonaws.services.cloudfront.model.CustomErrorResponses;
import com.amazonaws.services.cloudfront.model.CustomHeaders;
import com.amazonaws.services.cloudfront.model.CustomOriginConfig;
import com.amazonaws.services.cloudfront.model.DefaultCacheBehavior;
import com.amazonaws.services.cloudfront.model.DistributionConfig;
import com.amazonaws.services.cloudfront.model.ForwardedValues;
import com.amazonaws.services.cloudfront.model.GeoRestriction;
import com.amazonaws.services.cloudfront.model.Headers;
import com.amazonaws.services.cloudfront.model.LoggingConfig;
import com.amazonaws.services.cloudfront.model.Origin;
import com.amazonaws.services.cloudfront.model.OriginCustomHeader;
import com.amazonaws.services.cloudfront.model.OriginSslProtocols;
import com.amazonaws.services.cloudfront.model.Origins;
import com.amazonaws.services.cloudfront.model.QueryStringCacheKeys;
import com.amazonaws.services.cloudfront.model.Restrictions;
import com.amazonaws.services.cloudfront.model.S3OriginConfig;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.services.cloudfront.model.ViewerCertificate;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.util.Iterator;

public class CreateDistributionRequestMarshaller
implements Marshaller<Request<CreateDistributionRequest>, CreateDistributionRequest> {
    @Override
    public Request<CreateDistributionRequest> marshall(CreateDistributionRequest createDistributionRequest) {
        if (createDistributionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDistributionRequest> request = new DefaultRequest<CreateDistributionRequest>(createDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2016-09-29/distribution";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2016-09-29/");
            DistributionConfig distributionConfig = createDistributionRequest.getDistributionConfig();
            if (distributionConfig != null) {
                Restrictions restrictions;
                ViewerCertificate viewerCertificate;
                LoggingConfig logging;
                CustomErrorResponses customErrorResponses;
                CacheBehaviors cacheBehaviors;
                DefaultCacheBehavior defaultCacheBehavior;
                Origins origins;
                Aliases aliases;
                xmlWriter.startElement("DistributionConfig");
                if (distributionConfig.getCallerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(distributionConfig.getCallerReference()).endElement();
                }
                if ((aliases = distributionConfig.getAliases()) != null) {
                    SdkInternalList aliasesItemsList;
                    xmlWriter.startElement("Aliases");
                    if (aliases.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value(aliases.getQuantity()).endElement();
                    }
                    if (!(aliasesItemsList = (SdkInternalList)aliases.getItems()).isEmpty() || !aliasesItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (Object aliasesItemsListValue : aliasesItemsList) {
                            xmlWriter.startElement("CNAME");
                            xmlWriter.value((String)aliasesItemsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (distributionConfig.getDefaultRootObject() != null) {
                    xmlWriter.startElement("DefaultRootObject").value(distributionConfig.getDefaultRootObject()).endElement();
                }
                if ((origins = distributionConfig.getOrigins()) != null) {
                    SdkInternalList originsItemsList;
                    xmlWriter.startElement("Origins");
                    if (origins.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value(origins.getQuantity()).endElement();
                    }
                    if (!(originsItemsList = (SdkInternalList)origins.getItems()).isEmpty() || !originsItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (Origin originsItemsListValue : originsItemsList) {
                            Iterator customOriginConfig;
                            S3OriginConfig s3OriginConfig;
                            CustomHeaders customHeaders;
                            xmlWriter.startElement("Origin");
                            if (originsItemsListValue.getId() != null) {
                                xmlWriter.startElement("Id").value(originsItemsListValue.getId()).endElement();
                            }
                            if (originsItemsListValue.getDomainName() != null) {
                                xmlWriter.startElement("DomainName").value(originsItemsListValue.getDomainName()).endElement();
                            }
                            if (originsItemsListValue.getOriginPath() != null) {
                                xmlWriter.startElement("OriginPath").value(originsItemsListValue.getOriginPath()).endElement();
                            }
                            if ((customHeaders = originsItemsListValue.getCustomHeaders()) != null) {
                                SdkInternalList customHeadersItemsList;
                                xmlWriter.startElement("CustomHeaders");
                                if (customHeaders.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value(customHeaders.getQuantity()).endElement();
                                }
                                if (!(customHeadersItemsList = (SdkInternalList)customHeaders.getItems()).isEmpty() || !customHeadersItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (OriginCustomHeader customHeadersItemsListValue : customHeadersItemsList) {
                                        xmlWriter.startElement("OriginCustomHeader");
                                        if (customHeadersItemsListValue.getHeaderName() != null) {
                                            xmlWriter.startElement("HeaderName").value(customHeadersItemsListValue.getHeaderName()).endElement();
                                        }
                                        if (customHeadersItemsListValue.getHeaderValue() != null) {
                                            xmlWriter.startElement("HeaderValue").value(customHeadersItemsListValue.getHeaderValue()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((s3OriginConfig = originsItemsListValue.getS3OriginConfig()) != null) {
                                xmlWriter.startElement("S3OriginConfig");
                                if (s3OriginConfig.getOriginAccessIdentity() != null) {
                                    xmlWriter.startElement("OriginAccessIdentity").value(s3OriginConfig.getOriginAccessIdentity()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((customOriginConfig = originsItemsListValue.getCustomOriginConfig()) != null) {
                                OriginSslProtocols originSslProtocols;
                                xmlWriter.startElement("CustomOriginConfig");
                                if (((CustomOriginConfig)((Object)customOriginConfig)).getHTTPPort() != null) {
                                    xmlWriter.startElement("HTTPPort").value(((CustomOriginConfig)((Object)customOriginConfig)).getHTTPPort()).endElement();
                                }
                                if (((CustomOriginConfig)((Object)customOriginConfig)).getHTTPSPort() != null) {
                                    xmlWriter.startElement("HTTPSPort").value(((CustomOriginConfig)((Object)customOriginConfig)).getHTTPSPort()).endElement();
                                }
                                if (((CustomOriginConfig)((Object)customOriginConfig)).getOriginProtocolPolicy() != null) {
                                    xmlWriter.startElement("OriginProtocolPolicy").value(((CustomOriginConfig)((Object)customOriginConfig)).getOriginProtocolPolicy()).endElement();
                                }
                                if ((originSslProtocols = ((CustomOriginConfig)((Object)customOriginConfig)).getOriginSslProtocols()) != null) {
                                    SdkInternalList originSslProtocolsItemsList;
                                    xmlWriter.startElement("OriginSslProtocols");
                                    if (originSslProtocols.getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value(originSslProtocols.getQuantity()).endElement();
                                    }
                                    if (!(originSslProtocolsItemsList = (SdkInternalList)originSslProtocols.getItems()).isEmpty() || !originSslProtocolsItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        for (Object originSslProtocolsItemsListValue : originSslProtocolsItemsList) {
                                            xmlWriter.startElement("SslProtocol");
                                            xmlWriter.value((String)originSslProtocolsItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((defaultCacheBehavior = distributionConfig.getDefaultCacheBehavior()) != null) {
                    Object allowedMethods;
                    TrustedSigners trustedSigners;
                    ForwardedValues forwardedValues;
                    xmlWriter.startElement("DefaultCacheBehavior");
                    if (defaultCacheBehavior.getTargetOriginId() != null) {
                        xmlWriter.startElement("TargetOriginId").value(defaultCacheBehavior.getTargetOriginId()).endElement();
                    }
                    if ((forwardedValues = defaultCacheBehavior.getForwardedValues()) != null) {
                        Object queryStringCacheKeys;
                        Headers headers;
                        CookiePreference cookies;
                        xmlWriter.startElement("ForwardedValues");
                        if (forwardedValues.getQueryString() != null) {
                            xmlWriter.startElement("QueryString").value(forwardedValues.getQueryString()).endElement();
                        }
                        if ((cookies = forwardedValues.getCookies()) != null) {
                            CookieNames whitelistedNames;
                            xmlWriter.startElement("Cookies");
                            if (cookies.getForward() != null) {
                                xmlWriter.startElement("Forward").value(cookies.getForward()).endElement();
                            }
                            if ((whitelistedNames = cookies.getWhitelistedNames()) != null) {
                                SdkInternalList cookieNamesItemsList;
                                xmlWriter.startElement("WhitelistedNames");
                                if (whitelistedNames.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value(whitelistedNames.getQuantity()).endElement();
                                }
                                if (!(cookieNamesItemsList = (SdkInternalList)whitelistedNames.getItems()).isEmpty() || !cookieNamesItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (String cookieNamesItemsListValue : cookieNamesItemsList) {
                                        xmlWriter.startElement("Name");
                                        xmlWriter.value(cookieNamesItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((headers = forwardedValues.getHeaders()) != null) {
                            SdkInternalList headersItemsList;
                            xmlWriter.startElement("Headers");
                            if (headers.getQuantity() != null) {
                                xmlWriter.startElement("Quantity").value(headers.getQuantity()).endElement();
                            }
                            if (!(headersItemsList = (SdkInternalList)headers.getItems()).isEmpty() || !headersItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");
                                for (Object headersItemsListValue : headersItemsList) {
                                    xmlWriter.startElement("Name");
                                    xmlWriter.value((String)headersItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((queryStringCacheKeys = forwardedValues.getQueryStringCacheKeys()) != null) {
                            SdkInternalList queryStringCacheKeysItemsList;
                            xmlWriter.startElement("QueryStringCacheKeys");
                            if (((QueryStringCacheKeys)queryStringCacheKeys).getQuantity() != null) {
                                xmlWriter.startElement("Quantity").value(((QueryStringCacheKeys)queryStringCacheKeys).getQuantity()).endElement();
                            }
                            if (!(queryStringCacheKeysItemsList = (SdkInternalList)((QueryStringCacheKeys)queryStringCacheKeys).getItems()).isEmpty() || !queryStringCacheKeysItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");
                                for (Object queryStringCacheKeysItemsListValue : queryStringCacheKeysItemsList) {
                                    xmlWriter.startElement("Name");
                                    xmlWriter.value((String)queryStringCacheKeysItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((trustedSigners = defaultCacheBehavior.getTrustedSigners()) != null) {
                        SdkInternalList trustedSignersItemsList;
                        xmlWriter.startElement("TrustedSigners");
                        if (trustedSigners.getEnabled() != null) {
                            xmlWriter.startElement("Enabled").value(trustedSigners.getEnabled()).endElement();
                        }
                        if (trustedSigners.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value(trustedSigners.getQuantity()).endElement();
                        }
                        if (!(trustedSignersItemsList = (SdkInternalList)trustedSigners.getItems()).isEmpty() || !trustedSignersItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (Object trustedSignersItemsListValue : trustedSignersItemsList) {
                                xmlWriter.startElement("AwsAccountNumber");
                                xmlWriter.value((String)trustedSignersItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (defaultCacheBehavior.getViewerProtocolPolicy() != null) {
                        xmlWriter.startElement("ViewerProtocolPolicy").value(defaultCacheBehavior.getViewerProtocolPolicy()).endElement();
                    }
                    if (defaultCacheBehavior.getMinTTL() != null) {
                        xmlWriter.startElement("MinTTL").value(defaultCacheBehavior.getMinTTL()).endElement();
                    }
                    if ((allowedMethods = defaultCacheBehavior.getAllowedMethods()) != null) {
                        CachedMethods cachedMethods;
                        SdkInternalList allowedMethodsItemsList;
                        xmlWriter.startElement("AllowedMethods");
                        if (((AllowedMethods)allowedMethods).getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value(((AllowedMethods)allowedMethods).getQuantity()).endElement();
                        }
                        if (!(allowedMethodsItemsList = (SdkInternalList)((AllowedMethods)allowedMethods).getItems()).isEmpty() || !allowedMethodsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String allowedMethodsItemsListValue : allowedMethodsItemsList) {
                                xmlWriter.startElement("Method");
                                xmlWriter.value(allowedMethodsItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((cachedMethods = ((AllowedMethods)allowedMethods).getCachedMethods()) != null) {
                            SdkInternalList cachedMethodsItemsList;
                            xmlWriter.startElement("CachedMethods");
                            if (cachedMethods.getQuantity() != null) {
                                xmlWriter.startElement("Quantity").value(cachedMethods.getQuantity()).endElement();
                            }
                            if (!(cachedMethodsItemsList = (SdkInternalList)cachedMethods.getItems()).isEmpty() || !cachedMethodsItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");
                                for (String cachedMethodsItemsListValue : cachedMethodsItemsList) {
                                    xmlWriter.startElement("Method");
                                    xmlWriter.value(cachedMethodsItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (defaultCacheBehavior.getSmoothStreaming() != null) {
                        xmlWriter.startElement("SmoothStreaming").value(defaultCacheBehavior.getSmoothStreaming()).endElement();
                    }
                    if (defaultCacheBehavior.getDefaultTTL() != null) {
                        xmlWriter.startElement("DefaultTTL").value(defaultCacheBehavior.getDefaultTTL()).endElement();
                    }
                    if (defaultCacheBehavior.getMaxTTL() != null) {
                        xmlWriter.startElement("MaxTTL").value(defaultCacheBehavior.getMaxTTL()).endElement();
                    }
                    if (defaultCacheBehavior.getCompress() != null) {
                        xmlWriter.startElement("Compress").value(defaultCacheBehavior.getCompress()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((cacheBehaviors = distributionConfig.getCacheBehaviors()) != null) {
                    SdkInternalList cacheBehaviorsItemsList;
                    xmlWriter.startElement("CacheBehaviors");
                    if (cacheBehaviors.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value(cacheBehaviors.getQuantity()).endElement();
                    }
                    if (!(cacheBehaviorsItemsList = (SdkInternalList)cacheBehaviors.getItems()).isEmpty() || !cacheBehaviorsItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (Object cacheBehaviorsItemsListValue : cacheBehaviorsItemsList) {
                            AllowedMethods allowedMethods;
                            TrustedSigners trustedSigners;
                            Object queryStringCacheKeys;
                            ForwardedValues forwardedValues;
                            xmlWriter.startElement("CacheBehavior");
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getPathPattern() != null) {
                                xmlWriter.startElement("PathPattern").value(((CacheBehavior)cacheBehaviorsItemsListValue).getPathPattern()).endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getTargetOriginId() != null) {
                                xmlWriter.startElement("TargetOriginId").value(((CacheBehavior)cacheBehaviorsItemsListValue).getTargetOriginId()).endElement();
                            }
                            if ((forwardedValues = ((CacheBehavior)cacheBehaviorsItemsListValue).getForwardedValues()) != null) {
                                Headers headers;
                                CookiePreference cookies;
                                xmlWriter.startElement("ForwardedValues");
                                if (forwardedValues.getQueryString() != null) {
                                    xmlWriter.startElement("QueryString").value(forwardedValues.getQueryString()).endElement();
                                }
                                if ((cookies = forwardedValues.getCookies()) != null) {
                                    CookieNames whitelistedNames;
                                    xmlWriter.startElement("Cookies");
                                    if (cookies.getForward() != null) {
                                        xmlWriter.startElement("Forward").value(cookies.getForward()).endElement();
                                    }
                                    if ((whitelistedNames = cookies.getWhitelistedNames()) != null) {
                                        SdkInternalList cookieNamesItemsList;
                                        xmlWriter.startElement("WhitelistedNames");
                                        if (whitelistedNames.getQuantity() != null) {
                                            xmlWriter.startElement("Quantity").value(whitelistedNames.getQuantity()).endElement();
                                        }
                                        if (!(cookieNamesItemsList = (SdkInternalList)whitelistedNames.getItems()).isEmpty() || !cookieNamesItemsList.isAutoConstruct()) {
                                            xmlWriter.startElement("Items");
                                            for (String cookieNamesItemsListValue : cookieNamesItemsList) {
                                                xmlWriter.startElement("Name");
                                                xmlWriter.value(cookieNamesItemsListValue);
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((headers = forwardedValues.getHeaders()) != null) {
                                    SdkInternalList headersItemsList;
                                    xmlWriter.startElement("Headers");
                                    if (headers.getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value(headers.getQuantity()).endElement();
                                    }
                                    if (!(headersItemsList = (SdkInternalList)headers.getItems()).isEmpty() || !headersItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        for (Object headersItemsListValue : headersItemsList) {
                                            xmlWriter.startElement("Name");
                                            xmlWriter.value((String)headersItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((queryStringCacheKeys = forwardedValues.getQueryStringCacheKeys()) != null) {
                                    SdkInternalList queryStringCacheKeysItemsList;
                                    xmlWriter.startElement("QueryStringCacheKeys");
                                    if (((QueryStringCacheKeys)queryStringCacheKeys).getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value(((QueryStringCacheKeys)queryStringCacheKeys).getQuantity()).endElement();
                                    }
                                    if (!(queryStringCacheKeysItemsList = (SdkInternalList)((QueryStringCacheKeys)queryStringCacheKeys).getItems()).isEmpty() || !queryStringCacheKeysItemsList.isAutoConstruct()) {
                                        Object headersItemsListValue;
                                        xmlWriter.startElement("Items");
                                        headersItemsListValue = queryStringCacheKeysItemsList.iterator();
                                        while (headersItemsListValue.hasNext()) {
                                            String queryStringCacheKeysItemsListValue = (String)headersItemsListValue.next();
                                            xmlWriter.startElement("Name");
                                            xmlWriter.value(queryStringCacheKeysItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((trustedSigners = ((CacheBehavior)cacheBehaviorsItemsListValue).getTrustedSigners()) != null) {
                                SdkInternalList trustedSignersItemsList;
                                xmlWriter.startElement("TrustedSigners");
                                if (trustedSigners.getEnabled() != null) {
                                    xmlWriter.startElement("Enabled").value(trustedSigners.getEnabled()).endElement();
                                }
                                if (trustedSigners.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value(trustedSigners.getQuantity()).endElement();
                                }
                                if (!(trustedSignersItemsList = (SdkInternalList)trustedSigners.getItems()).isEmpty() || !trustedSignersItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    queryStringCacheKeys = trustedSignersItemsList.iterator();
                                    while (queryStringCacheKeys.hasNext()) {
                                        String trustedSignersItemsListValue = (String)queryStringCacheKeys.next();
                                        xmlWriter.startElement("AwsAccountNumber");
                                        xmlWriter.value(trustedSignersItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getViewerProtocolPolicy() != null) {
                                xmlWriter.startElement("ViewerProtocolPolicy").value(((CacheBehavior)cacheBehaviorsItemsListValue).getViewerProtocolPolicy()).endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getMinTTL() != null) {
                                xmlWriter.startElement("MinTTL").value(((CacheBehavior)cacheBehaviorsItemsListValue).getMinTTL()).endElement();
                            }
                            if ((allowedMethods = ((CacheBehavior)cacheBehaviorsItemsListValue).getAllowedMethods()) != null) {
                                CachedMethods cachedMethods;
                                SdkInternalList allowedMethodsItemsList;
                                xmlWriter.startElement("AllowedMethods");
                                if (allowedMethods.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value(allowedMethods.getQuantity()).endElement();
                                }
                                if (!(allowedMethodsItemsList = (SdkInternalList)allowedMethods.getItems()).isEmpty() || !allowedMethodsItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (String allowedMethodsItemsListValue : allowedMethodsItemsList) {
                                        xmlWriter.startElement("Method");
                                        xmlWriter.value(allowedMethodsItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((cachedMethods = allowedMethods.getCachedMethods()) != null) {
                                    SdkInternalList cachedMethodsItemsList;
                                    xmlWriter.startElement("CachedMethods");
                                    if (cachedMethods.getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value(cachedMethods.getQuantity()).endElement();
                                    }
                                    if (!(cachedMethodsItemsList = (SdkInternalList)cachedMethods.getItems()).isEmpty() || !cachedMethodsItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        for (String cachedMethodsItemsListValue : cachedMethodsItemsList) {
                                            xmlWriter.startElement("Method");
                                            xmlWriter.value(cachedMethodsItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getSmoothStreaming() != null) {
                                xmlWriter.startElement("SmoothStreaming").value(((CacheBehavior)cacheBehaviorsItemsListValue).getSmoothStreaming()).endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getDefaultTTL() != null) {
                                xmlWriter.startElement("DefaultTTL").value(((CacheBehavior)cacheBehaviorsItemsListValue).getDefaultTTL()).endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getMaxTTL() != null) {
                                xmlWriter.startElement("MaxTTL").value(((CacheBehavior)cacheBehaviorsItemsListValue).getMaxTTL()).endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getCompress() != null) {
                                xmlWriter.startElement("Compress").value(((CacheBehavior)cacheBehaviorsItemsListValue).getCompress()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((customErrorResponses = distributionConfig.getCustomErrorResponses()) != null) {
                    SdkInternalList customErrorResponsesItemsList;
                    xmlWriter.startElement("CustomErrorResponses");
                    if (customErrorResponses.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value(customErrorResponses.getQuantity()).endElement();
                    }
                    if (!(customErrorResponsesItemsList = (SdkInternalList)customErrorResponses.getItems()).isEmpty() || !customErrorResponsesItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (CustomErrorResponse customErrorResponsesItemsListValue : customErrorResponsesItemsList) {
                            xmlWriter.startElement("CustomErrorResponse");
                            if (customErrorResponsesItemsListValue.getErrorCode() != null) {
                                xmlWriter.startElement("ErrorCode").value(customErrorResponsesItemsListValue.getErrorCode()).endElement();
                            }
                            if (customErrorResponsesItemsListValue.getResponsePagePath() != null) {
                                xmlWriter.startElement("ResponsePagePath").value(customErrorResponsesItemsListValue.getResponsePagePath()).endElement();
                            }
                            if (customErrorResponsesItemsListValue.getResponseCode() != null) {
                                xmlWriter.startElement("ResponseCode").value(customErrorResponsesItemsListValue.getResponseCode()).endElement();
                            }
                            if (customErrorResponsesItemsListValue.getErrorCachingMinTTL() != null) {
                                xmlWriter.startElement("ErrorCachingMinTTL").value(customErrorResponsesItemsListValue.getErrorCachingMinTTL()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (distributionConfig.getComment() != null) {
                    xmlWriter.startElement("Comment").value(distributionConfig.getComment()).endElement();
                }
                if ((logging = distributionConfig.getLogging()) != null) {
                    xmlWriter.startElement("Logging");
                    if (logging.getEnabled() != null) {
                        xmlWriter.startElement("Enabled").value(logging.getEnabled()).endElement();
                    }
                    if (logging.getIncludeCookies() != null) {
                        xmlWriter.startElement("IncludeCookies").value(logging.getIncludeCookies()).endElement();
                    }
                    if (logging.getBucket() != null) {
                        xmlWriter.startElement("Bucket").value(logging.getBucket()).endElement();
                    }
                    if (logging.getPrefix() != null) {
                        xmlWriter.startElement("Prefix").value(logging.getPrefix()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (distributionConfig.getPriceClass() != null) {
                    xmlWriter.startElement("PriceClass").value(distributionConfig.getPriceClass()).endElement();
                }
                if (distributionConfig.getEnabled() != null) {
                    xmlWriter.startElement("Enabled").value(distributionConfig.getEnabled()).endElement();
                }
                if ((viewerCertificate = distributionConfig.getViewerCertificate()) != null) {
                    xmlWriter.startElement("ViewerCertificate");
                    if (viewerCertificate.getCloudFrontDefaultCertificate() != null) {
                        xmlWriter.startElement("CloudFrontDefaultCertificate").value(viewerCertificate.getCloudFrontDefaultCertificate()).endElement();
                    }
                    if (viewerCertificate.getIAMCertificateId() != null) {
                        xmlWriter.startElement("IAMCertificateId").value(viewerCertificate.getIAMCertificateId()).endElement();
                    }
                    if (viewerCertificate.getACMCertificateArn() != null) {
                        xmlWriter.startElement("ACMCertificateArn").value(viewerCertificate.getACMCertificateArn()).endElement();
                    }
                    if (viewerCertificate.getSSLSupportMethod() != null) {
                        xmlWriter.startElement("SSLSupportMethod").value(viewerCertificate.getSSLSupportMethod()).endElement();
                    }
                    if (viewerCertificate.getMinimumProtocolVersion() != null) {
                        xmlWriter.startElement("MinimumProtocolVersion").value(viewerCertificate.getMinimumProtocolVersion()).endElement();
                    }
                    if (viewerCertificate.getCertificate() != null) {
                        xmlWriter.startElement("Certificate").value(viewerCertificate.getCertificate()).endElement();
                    }
                    if (viewerCertificate.getCertificateSource() != null) {
                        xmlWriter.startElement("CertificateSource").value(viewerCertificate.getCertificateSource()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((restrictions = distributionConfig.getRestrictions()) != null) {
                    xmlWriter.startElement("Restrictions");
                    GeoRestriction geoRestriction = restrictions.getGeoRestriction();
                    if (geoRestriction != null) {
                        SdkInternalList geoRestrictionItemsList;
                        xmlWriter.startElement("GeoRestriction");
                        if (geoRestriction.getRestrictionType() != null) {
                            xmlWriter.startElement("RestrictionType").value(geoRestriction.getRestrictionType()).endElement();
                        }
                        if (geoRestriction.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value(geoRestriction.getQuantity()).endElement();
                        }
                        if (!(geoRestrictionItemsList = (SdkInternalList)geoRestriction.getItems()).isEmpty() || !geoRestrictionItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String geoRestrictionItemsListValue : geoRestrictionItemsList) {
                                xmlWriter.startElement("Location");
                                xmlWriter.value(geoRestrictionItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (distributionConfig.getWebACLId() != null) {
                    xmlWriter.startElement("WebACLId").value(distributionConfig.getWebACLId()).endElement();
                }
                if (distributionConfig.getHttpVersion() != null) {
                    xmlWriter.startElement("HttpVersion").value(distributionConfig.getHttpVersion()).endElement();
                }
                if (distributionConfig.getIsIPV6Enabled() != null) {
                    xmlWriter.startElement("IsIPV6Enabled").value(distributionConfig.getIsIPV6Enabled()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

