/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.budgets.model.DeleteBudgetRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeleteBudgetRequestMarshaller
implements Marshaller<Request<DeleteBudgetRequest>, DeleteBudgetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteBudgetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteBudgetRequest> marshall(DeleteBudgetRequest deleteBudgetRequest) {
        if (deleteBudgetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteBudgetRequest> request = new DefaultRequest<DeleteBudgetRequest>(deleteBudgetRequest, "AWSBudgets");
        request.addHeader("X-Amz-Target", "AWSBudgetServiceGateway.DeleteBudget");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteBudgetRequest.getAccountId() != null) {
                jsonGenerator.writeFieldName("AccountId").writeValue(deleteBudgetRequest.getAccountId());
            }
            if (deleteBudgetRequest.getBudgetName() != null) {
                jsonGenerator.writeFieldName("BudgetName").writeValue(deleteBudgetRequest.getBudgetName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

