/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.ApiStage;
import com.amazonaws.services.apigateway.model.UsagePlan;
import com.amazonaws.services.apigateway.model.transform.ApiStageJsonMarshaller;
import com.amazonaws.services.apigateway.model.transform.QuotaSettingsJsonMarshaller;
import com.amazonaws.services.apigateway.model.transform.ThrottleSettingsJsonMarshaller;
import java.util.List;

public class UsagePlanJsonMarshaller {
    private static UsagePlanJsonMarshaller instance;

    public void marshall(UsagePlan usagePlan, StructuredJsonGenerator jsonGenerator) {
        if (usagePlan == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ApiStage> apiStagesList;
            jsonGenerator.writeStartObject();
            if (usagePlan.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(usagePlan.getId());
            }
            if (usagePlan.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(usagePlan.getName());
            }
            if (usagePlan.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(usagePlan.getDescription());
            }
            if ((apiStagesList = usagePlan.getApiStages()) != null) {
                jsonGenerator.writeFieldName("apiStages");
                jsonGenerator.writeStartArray();
                for (ApiStage apiStagesListValue : apiStagesList) {
                    if (apiStagesListValue == null) continue;
                    ApiStageJsonMarshaller.getInstance().marshall(apiStagesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (usagePlan.getThrottle() != null) {
                jsonGenerator.writeFieldName("throttle");
                ThrottleSettingsJsonMarshaller.getInstance().marshall(usagePlan.getThrottle(), jsonGenerator);
            }
            if (usagePlan.getQuota() != null) {
                jsonGenerator.writeFieldName("quota");
                QuotaSettingsJsonMarshaller.getInstance().marshall(usagePlan.getQuota(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static UsagePlanJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new UsagePlanJsonMarshaller();
        }
        return instance;
    }
}

