/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.PutIntegrationResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class PutIntegrationResponseRequestMarshaller
implements Marshaller<Request<PutIntegrationResponseRequest>, PutIntegrationResponseRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutIntegrationResponseRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PutIntegrationResponseRequest> marshall(PutIntegrationResponseRequest putIntegrationResponseRequest) {
        if (putIntegrationResponseRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutIntegrationResponseRequest> request = new DefaultRequest<PutIntegrationResponseRequest>(putIntegrationResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putIntegrationResponseRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(putIntegrationResponseRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", putIntegrationResponseRequest.getResourceId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(putIntegrationResponseRequest.getResourceId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", putIntegrationResponseRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(putIntegrationResponseRequest.getHttpMethod()), false) : "");
        uriResourcePath = uriResourcePath.replace("{status_code}", putIntegrationResponseRequest.getStatusCode() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(putIntegrationResponseRequest.getStatusCode()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> responseTemplatesMap;
            Map<String, String> responseParametersMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putIntegrationResponseRequest.getSelectionPattern() != null) {
                jsonGenerator.writeFieldName("selectionPattern").writeValue(putIntegrationResponseRequest.getSelectionPattern());
            }
            if ((responseParametersMap = putIntegrationResponseRequest.getResponseParameters()) != null) {
                jsonGenerator.writeFieldName("responseParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> responseParametersMapValue : responseParametersMap.entrySet()) {
                    if (responseParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)responseParametersMapValue.getKey());
                    jsonGenerator.writeValue((String)responseParametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((responseTemplatesMap = putIntegrationResponseRequest.getResponseTemplates()) != null) {
                jsonGenerator.writeFieldName("responseTemplates");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : responseTemplatesMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    jsonGenerator.writeValue((String)entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

