/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.CreateStageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class CreateStageRequestMarshaller
implements Marshaller<Request<CreateStageRequest>, CreateStageRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateStageRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateStageRequest> marshall(CreateStageRequest createStageRequest) {
        if (createStageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateStageRequest> request = new DefaultRequest<CreateStageRequest>(createStageRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/stages";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", createStageRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(createStageRequest.getRestApiId()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> variablesMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createStageRequest.getStageName() != null) {
                jsonGenerator.writeFieldName("stageName").writeValue(createStageRequest.getStageName());
            }
            if (createStageRequest.getDeploymentId() != null) {
                jsonGenerator.writeFieldName("deploymentId").writeValue(createStageRequest.getDeploymentId());
            }
            if (createStageRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(createStageRequest.getDescription());
            }
            if (createStageRequest.getCacheClusterEnabled() != null) {
                jsonGenerator.writeFieldName("cacheClusterEnabled").writeValue(createStageRequest.getCacheClusterEnabled());
            }
            if (createStageRequest.getCacheClusterSize() != null) {
                jsonGenerator.writeFieldName("cacheClusterSize").writeValue(createStageRequest.getCacheClusterSize());
            }
            if ((variablesMap = createStageRequest.getVariables()) != null) {
                jsonGenerator.writeFieldName("variables");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> variablesMapValue : variablesMap.entrySet()) {
                    if (variablesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(variablesMapValue.getKey());
                    jsonGenerator.writeValue(variablesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

