/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.RegisterCertificateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class RegisterCertificateRequestMarshaller
implements Marshaller<Request<RegisterCertificateRequest>, RegisterCertificateRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RegisterCertificateRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RegisterCertificateRequest> marshall(RegisterCertificateRequest registerCertificateRequest) {
        if (registerCertificateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterCertificateRequest> request = new DefaultRequest<RegisterCertificateRequest>(registerCertificateRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/certificate/register";
        request.setResourcePath(uriResourcePath);
        if (registerCertificateRequest.getSetAsActive() != null) {
            request.addParameter("setAsActive", StringUtils.fromBoolean(registerCertificateRequest.getSetAsActive()));
        }
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerCertificateRequest.getCertificatePem() != null) {
                jsonGenerator.writeFieldName("certificatePem").writeValue(registerCertificateRequest.getCertificatePem());
            }
            if (registerCertificateRequest.getCaCertificatePem() != null) {
                jsonGenerator.writeFieldName("caCertificatePem").writeValue(registerCertificateRequest.getCaCertificatePem());
            }
            if (registerCertificateRequest.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(registerCertificateRequest.getStatus());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

