/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitosync.model.PushSync;

public class PushSyncJsonMarshaller {
    private static PushSyncJsonMarshaller instance;

    public void marshall(PushSync pushSync, StructuredJsonGenerator jsonGenerator) {
        if (pushSync == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList applicationArnsList = (SdkInternalList)pushSync.getApplicationArns();
            if (!applicationArnsList.isEmpty() || !applicationArnsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ApplicationArns");
                jsonGenerator.writeStartArray();
                for (String applicationArnsListValue : applicationArnsList) {
                    if (applicationArnsListValue == null) continue;
                    jsonGenerator.writeValue(applicationArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (pushSync.getRoleArn() != null) {
                jsonGenerator.writeFieldName("RoleArn").writeValue(pushSync.getRoleArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PushSyncJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PushSyncJsonMarshaller();
        }
        return instance;
    }
}

