/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudsearchv2.model.DescribeSuggestersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeSuggestersRequestMarshaller
implements Marshaller<Request<DescribeSuggestersRequest>, DescribeSuggestersRequest> {
    @Override
    public Request<DescribeSuggestersRequest> marshall(DescribeSuggestersRequest describeSuggestersRequest) {
        SdkInternalList suggesterNamesList;
        if (describeSuggestersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeSuggestersRequest> request = new DefaultRequest<DescribeSuggestersRequest>(describeSuggestersRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeSuggesters");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSuggestersRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(describeSuggestersRequest.getDomainName()));
        }
        if (!(suggesterNamesList = (SdkInternalList)describeSuggestersRequest.getSuggesterNames()).isEmpty() || !suggesterNamesList.isAutoConstruct()) {
            int suggesterNamesListIndex = 1;
            for (String suggesterNamesListValue : suggesterNamesList) {
                if (suggesterNamesListValue != null) {
                    request.addParameter("SuggesterNames.member." + suggesterNamesListIndex, StringUtils.fromString(suggesterNamesListValue));
                }
                ++suggesterNamesListIndex;
            }
        }
        if (describeSuggestersRequest.getDeployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean(describeSuggestersRequest.getDeployed()));
        }
        return request;
    }
}

