/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.util.ValidationUtils;
import java.util.Random;

public class PredefinedBackoffStrategies {
    static final int SDK_DEFAULT_BASE_DELAY = 100;
    static final int SDK_DEFAULT_THROTTLED_BASE_DELAY = 500;
    static final int SDK_DEFAULT_MAX_BACKOFF_IN_MILLISECONDS = 20000;
    static final int DYNAMODB_DEFAULT_BASE_DELAY = 25;
    private static final int MAX_RETRIES = 30;

    private static int calculateExponentialDelay(int retriesAttempted, int baseDelay, int maxBackoffTime) {
        int retries = Math.min(retriesAttempted, 30);
        return (int)Math.min((1L << retries) * (long)baseDelay, (long)maxBackoffTime);
    }

    static class SDKDefaultBackoffStrategy
    implements RetryPolicy.BackoffStrategy {
        private final RetryPolicy.BackoffStrategy fullJitterBackoffStrategy;
        private final RetryPolicy.BackoffStrategy equalJitterBackoffStrategy;

        SDKDefaultBackoffStrategy() {
            this.fullJitterBackoffStrategy = new FullJitterBackoffStrategy(100, 20000);
            this.equalJitterBackoffStrategy = new EqualJitterBackoffStrategy(500, 20000);
        }

        SDKDefaultBackoffStrategy(int baseDelay, int throttledBaseDelay, int maxBackoff) {
            this.fullJitterBackoffStrategy = new FullJitterBackoffStrategy(baseDelay, maxBackoff);
            this.equalJitterBackoffStrategy = new EqualJitterBackoffStrategy(throttledBaseDelay, maxBackoff);
        }

        @Override
        public final long delayBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
            if (exception instanceof AmazonServiceException && RetryUtils.isThrottlingException((AmazonServiceException)exception)) {
                return this.equalJitterBackoffStrategy.delayBeforeNextRetry(originalRequest, exception, retriesAttempted);
            }
            return this.fullJitterBackoffStrategy.delayBeforeNextRetry(originalRequest, exception, retriesAttempted);
        }
    }

    public static class ExponentialBackoffStrategy
    implements RetryPolicy.BackoffStrategy {
        private final int baseDelay;
        private final int maxBackoffTime;

        public ExponentialBackoffStrategy(int baseDelay, int maxBackoffTime) {
            this.baseDelay = ValidationUtils.assertIsPositive(baseDelay, "Base delay");
            this.maxBackoffTime = ValidationUtils.assertIsPositive(maxBackoffTime, "Max backoff");
        }

        @Override
        public long delayBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
            return PredefinedBackoffStrategies.calculateExponentialDelay(retriesAttempted, this.baseDelay, this.maxBackoffTime);
        }
    }

    public static class EqualJitterBackoffStrategy
    implements RetryPolicy.BackoffStrategy {
        private final int baseDelay;
        private final int maxBackoffTime;
        private final Random random = new Random();

        public EqualJitterBackoffStrategy(int baseDelay, int maxBackoffTime) {
            this.baseDelay = ValidationUtils.assertIsPositive(baseDelay, "Base delay");
            this.maxBackoffTime = ValidationUtils.assertIsPositive(maxBackoffTime, "Max backoff");
        }

        @Override
        public long delayBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
            int ceil = PredefinedBackoffStrategies.calculateExponentialDelay(retriesAttempted, this.baseDelay, this.maxBackoffTime);
            return ceil / 2 + this.random.nextInt(ceil / 2 + 1);
        }
    }

    public static class FullJitterBackoffStrategy
    implements RetryPolicy.BackoffStrategy {
        private final int baseDelay;
        private final int maxBackoffTime;
        private final Random random = new Random();

        public FullJitterBackoffStrategy(int baseDelay, int maxBackoffTime) {
            this.baseDelay = ValidationUtils.assertIsPositive(baseDelay, "Base delay");
            this.maxBackoffTime = ValidationUtils.assertIsPositive(maxBackoffTime, "Max backoff");
        }

        @Override
        public long delayBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
            int ceil = PredefinedBackoffStrategies.calculateExponentialDelay(retriesAttempted, this.baseDelay, this.maxBackoffTime);
            return this.random.nextInt(ceil);
        }
    }
}

