/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.HostEntry;

public class HostEntryJsonMarshaller {
    private static HostEntryJsonMarshaller instance;

    public void marshall(HostEntry hostEntry, StructuredJsonGenerator jsonGenerator) {
        if (hostEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (hostEntry.getHostname() != null) {
                jsonGenerator.writeFieldName("hostname").writeValue(hostEntry.getHostname());
            }
            if (hostEntry.getIpAddress() != null) {
                jsonGenerator.writeFieldName("ipAddress").writeValue(hostEntry.getIpAddress());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static HostEntryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new HostEntryJsonMarshaller();
        }
        return instance;
    }
}

