/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.DescribeComplianceByResourceRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeComplianceByResourceRequestMarshaller
implements Marshaller<Request<DescribeComplianceByResourceRequest>, DescribeComplianceByResourceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeComplianceByResourceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeComplianceByResourceRequest> marshall(DescribeComplianceByResourceRequest describeComplianceByResourceRequest) {
        if (describeComplianceByResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeComplianceByResourceRequest> request = new DefaultRequest<DescribeComplianceByResourceRequest>(describeComplianceByResourceRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DescribeComplianceByResource");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList complianceTypesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeComplianceByResourceRequest.getResourceType() != null) {
                jsonGenerator.writeFieldName("ResourceType").writeValue(describeComplianceByResourceRequest.getResourceType());
            }
            if (describeComplianceByResourceRequest.getResourceId() != null) {
                jsonGenerator.writeFieldName("ResourceId").writeValue(describeComplianceByResourceRequest.getResourceId());
            }
            if (!(complianceTypesList = (SdkInternalList)describeComplianceByResourceRequest.getComplianceTypes()).isEmpty() || !complianceTypesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ComplianceTypes");
                jsonGenerator.writeStartArray();
                for (String complianceTypesListValue : complianceTypesList) {
                    if (complianceTypesListValue == null) continue;
                    jsonGenerator.writeValue(complianceTypesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeComplianceByResourceRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeComplianceByResourceRequest.getLimit());
            }
            if (describeComplianceByResourceRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeComplianceByResourceRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

