/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class SubscribeToDatasetRequestMarshaller
implements Marshaller<Request<SubscribeToDatasetRequest>, SubscribeToDatasetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SubscribeToDatasetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SubscribeToDatasetRequest> marshall(SubscribeToDatasetRequest subscribeToDatasetRequest) {
        if (subscribeToDatasetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SubscribeToDatasetRequest> request = new DefaultRequest<SubscribeToDatasetRequest>(subscribeToDatasetRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", subscribeToDatasetRequest.getIdentityPoolId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(subscribeToDatasetRequest.getIdentityPoolId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{IdentityId}", subscribeToDatasetRequest.getIdentityId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(subscribeToDatasetRequest.getIdentityId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{DatasetName}", subscribeToDatasetRequest.getDatasetName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(subscribeToDatasetRequest.getDatasetName()), false) : "");
        uriResourcePath = uriResourcePath.replace("{DeviceId}", subscribeToDatasetRequest.getDeviceId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(subscribeToDatasetRequest.getDeviceId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

