/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetClientCertificatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetClientCertificatesRequestMarshaller
implements Marshaller<Request<GetClientCertificatesRequest>, GetClientCertificatesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetClientCertificatesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetClientCertificatesRequest> marshall(GetClientCertificatesRequest getClientCertificatesRequest) {
        if (getClientCertificatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetClientCertificatesRequest> request = new DefaultRequest<GetClientCertificatesRequest>(getClientCertificatesRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/clientcertificates";
        request.setResourcePath(uriResourcePath);
        if (getClientCertificatesRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getClientCertificatesRequest.getPosition()));
        }
        if (getClientCertificatesRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getClientCertificatesRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

