/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalMap;
import java.io.Serializable;
import java.util.Map;

public class SetQueueAttributesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String queueUrl;
    private SdkInternalMap<String, String> attributes;

    public SetQueueAttributesRequest() {
    }

    public SetQueueAttributesRequest(String queueUrl, Map<String, String> attributes) {
        this.setQueueUrl(queueUrl);
        this.setAttributes(attributes);
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public SetQueueAttributesRequest withQueueUrl(String queueUrl) {
        this.setQueueUrl(queueUrl);
        return this;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SdkInternalMap();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes == null ? null : new SdkInternalMap<String, String>(attributes);
    }

    public SetQueueAttributesRequest withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public SetQueueAttributesRequest addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new SdkInternalMap();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public SetQueueAttributesRequest clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: " + this.getQueueUrl() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetQueueAttributesRequest)) {
            return false;
        }
        SetQueueAttributesRequest other = (SetQueueAttributesRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    @Override
    public SetQueueAttributesRequest clone() {
        return (SetQueueAttributesRequest)super.clone();
    }
}

