/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.RegisterWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.transform.TaskListJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class RegisterWorkflowTypeRequestMarshaller
implements Marshaller<Request<RegisterWorkflowTypeRequest>, RegisterWorkflowTypeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RegisterWorkflowTypeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RegisterWorkflowTypeRequest> marshall(RegisterWorkflowTypeRequest registerWorkflowTypeRequest) {
        if (registerWorkflowTypeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterWorkflowTypeRequest> request = new DefaultRequest<RegisterWorkflowTypeRequest>(registerWorkflowTypeRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.RegisterWorkflowType");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerWorkflowTypeRequest.getDomain() != null) {
                jsonGenerator.writeFieldName("domain").writeValue(registerWorkflowTypeRequest.getDomain());
            }
            if (registerWorkflowTypeRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(registerWorkflowTypeRequest.getName());
            }
            if (registerWorkflowTypeRequest.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(registerWorkflowTypeRequest.getVersion());
            }
            if (registerWorkflowTypeRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(registerWorkflowTypeRequest.getDescription());
            }
            if (registerWorkflowTypeRequest.getDefaultTaskStartToCloseTimeout() != null) {
                jsonGenerator.writeFieldName("defaultTaskStartToCloseTimeout").writeValue(registerWorkflowTypeRequest.getDefaultTaskStartToCloseTimeout());
            }
            if (registerWorkflowTypeRequest.getDefaultExecutionStartToCloseTimeout() != null) {
                jsonGenerator.writeFieldName("defaultExecutionStartToCloseTimeout").writeValue(registerWorkflowTypeRequest.getDefaultExecutionStartToCloseTimeout());
            }
            if (registerWorkflowTypeRequest.getDefaultTaskList() != null) {
                jsonGenerator.writeFieldName("defaultTaskList");
                TaskListJsonMarshaller.getInstance().marshall(registerWorkflowTypeRequest.getDefaultTaskList(), jsonGenerator);
            }
            if (registerWorkflowTypeRequest.getDefaultTaskPriority() != null) {
                jsonGenerator.writeFieldName("defaultTaskPriority").writeValue(registerWorkflowTypeRequest.getDefaultTaskPriority());
            }
            if (registerWorkflowTypeRequest.getDefaultChildPolicy() != null) {
                jsonGenerator.writeFieldName("defaultChildPolicy").writeValue(registerWorkflowTypeRequest.getDefaultChildPolicy());
            }
            if (registerWorkflowTypeRequest.getDefaultLambdaRole() != null) {
                jsonGenerator.writeFieldName("defaultLambdaRole").writeValue(registerWorkflowTypeRequest.getDefaultLambdaRole());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

