/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.route53.AmazonRoute53Async;
import com.amazonaws.services.route53.AmazonRoute53Client;
import com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest;
import com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneResult;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsResult;
import com.amazonaws.services.route53.model.ChangeTagsForResourceRequest;
import com.amazonaws.services.route53.model.ChangeTagsForResourceResult;
import com.amazonaws.services.route53.model.CreateHealthCheckRequest;
import com.amazonaws.services.route53.model.CreateHealthCheckResult;
import com.amazonaws.services.route53.model.CreateHostedZoneRequest;
import com.amazonaws.services.route53.model.CreateHostedZoneResult;
import com.amazonaws.services.route53.model.CreateReusableDelegationSetRequest;
import com.amazonaws.services.route53.model.CreateReusableDelegationSetResult;
import com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceRequest;
import com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceResult;
import com.amazonaws.services.route53.model.CreateTrafficPolicyRequest;
import com.amazonaws.services.route53.model.CreateTrafficPolicyResult;
import com.amazonaws.services.route53.model.CreateTrafficPolicyVersionRequest;
import com.amazonaws.services.route53.model.CreateTrafficPolicyVersionResult;
import com.amazonaws.services.route53.model.DeleteHealthCheckRequest;
import com.amazonaws.services.route53.model.DeleteHealthCheckResult;
import com.amazonaws.services.route53.model.DeleteHostedZoneRequest;
import com.amazonaws.services.route53.model.DeleteHostedZoneResult;
import com.amazonaws.services.route53.model.DeleteReusableDelegationSetRequest;
import com.amazonaws.services.route53.model.DeleteReusableDelegationSetResult;
import com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceRequest;
import com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceResult;
import com.amazonaws.services.route53.model.DeleteTrafficPolicyRequest;
import com.amazonaws.services.route53.model.DeleteTrafficPolicyResult;
import com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest;
import com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneResult;
import com.amazonaws.services.route53.model.GetChangeDetailsRequest;
import com.amazonaws.services.route53.model.GetChangeDetailsResult;
import com.amazonaws.services.route53.model.GetChangeRequest;
import com.amazonaws.services.route53.model.GetChangeResult;
import com.amazonaws.services.route53.model.GetCheckerIpRangesRequest;
import com.amazonaws.services.route53.model.GetCheckerIpRangesResult;
import com.amazonaws.services.route53.model.GetGeoLocationRequest;
import com.amazonaws.services.route53.model.GetGeoLocationResult;
import com.amazonaws.services.route53.model.GetHealthCheckCountRequest;
import com.amazonaws.services.route53.model.GetHealthCheckCountResult;
import com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonRequest;
import com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonResult;
import com.amazonaws.services.route53.model.GetHealthCheckRequest;
import com.amazonaws.services.route53.model.GetHealthCheckResult;
import com.amazonaws.services.route53.model.GetHealthCheckStatusRequest;
import com.amazonaws.services.route53.model.GetHealthCheckStatusResult;
import com.amazonaws.services.route53.model.GetHostedZoneCountRequest;
import com.amazonaws.services.route53.model.GetHostedZoneCountResult;
import com.amazonaws.services.route53.model.GetHostedZoneRequest;
import com.amazonaws.services.route53.model.GetHostedZoneResult;
import com.amazonaws.services.route53.model.GetReusableDelegationSetRequest;
import com.amazonaws.services.route53.model.GetReusableDelegationSetResult;
import com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountRequest;
import com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountResult;
import com.amazonaws.services.route53.model.GetTrafficPolicyInstanceRequest;
import com.amazonaws.services.route53.model.GetTrafficPolicyInstanceResult;
import com.amazonaws.services.route53.model.GetTrafficPolicyRequest;
import com.amazonaws.services.route53.model.GetTrafficPolicyResult;
import com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneRequest;
import com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneResult;
import com.amazonaws.services.route53.model.ListChangeBatchesByRRSetRequest;
import com.amazonaws.services.route53.model.ListChangeBatchesByRRSetResult;
import com.amazonaws.services.route53.model.ListGeoLocationsRequest;
import com.amazonaws.services.route53.model.ListGeoLocationsResult;
import com.amazonaws.services.route53.model.ListHealthChecksRequest;
import com.amazonaws.services.route53.model.ListHealthChecksResult;
import com.amazonaws.services.route53.model.ListHostedZonesByNameRequest;
import com.amazonaws.services.route53.model.ListHostedZonesByNameResult;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.services.route53.model.ListHostedZonesResult;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import com.amazonaws.services.route53.model.ListReusableDelegationSetsRequest;
import com.amazonaws.services.route53.model.ListReusableDelegationSetsResult;
import com.amazonaws.services.route53.model.ListTagsForResourceRequest;
import com.amazonaws.services.route53.model.ListTagsForResourceResult;
import com.amazonaws.services.route53.model.ListTagsForResourcesRequest;
import com.amazonaws.services.route53.model.ListTagsForResourcesResult;
import com.amazonaws.services.route53.model.ListTrafficPoliciesRequest;
import com.amazonaws.services.route53.model.ListTrafficPoliciesResult;
import com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest;
import com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResult;
import com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest;
import com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyResult;
import com.amazonaws.services.route53.model.ListTrafficPolicyInstancesRequest;
import com.amazonaws.services.route53.model.ListTrafficPolicyInstancesResult;
import com.amazonaws.services.route53.model.ListTrafficPolicyVersionsRequest;
import com.amazonaws.services.route53.model.ListTrafficPolicyVersionsResult;
import com.amazonaws.services.route53.model.TestDNSAnswerRequest;
import com.amazonaws.services.route53.model.TestDNSAnswerResult;
import com.amazonaws.services.route53.model.UpdateHealthCheckRequest;
import com.amazonaws.services.route53.model.UpdateHealthCheckResult;
import com.amazonaws.services.route53.model.UpdateHostedZoneCommentRequest;
import com.amazonaws.services.route53.model.UpdateHostedZoneCommentResult;
import com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentRequest;
import com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentResult;
import com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceRequest;
import com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonRoute53AsyncClient
extends AmazonRoute53Client
implements AmazonRoute53Async {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonRoute53AsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    public AmazonRoute53AsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRoute53AsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonRoute53AsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonRoute53AsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonRoute53AsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateVPCWithHostedZoneResult> associateVPCWithHostedZoneAsync(AssociateVPCWithHostedZoneRequest request) {
        return this.associateVPCWithHostedZoneAsync(request, null);
    }

    @Override
    public Future<AssociateVPCWithHostedZoneResult> associateVPCWithHostedZoneAsync(final AssociateVPCWithHostedZoneRequest request, final AsyncHandler<AssociateVPCWithHostedZoneRequest, AssociateVPCWithHostedZoneResult> asyncHandler) {
        return this.executorService.submit(new Callable<AssociateVPCWithHostedZoneResult>(){

            @Override
            public AssociateVPCWithHostedZoneResult call() throws Exception {
                AssociateVPCWithHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.associateVPCWithHostedZone(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ChangeResourceRecordSetsResult> changeResourceRecordSetsAsync(ChangeResourceRecordSetsRequest request) {
        return this.changeResourceRecordSetsAsync(request, null);
    }

    @Override
    public Future<ChangeResourceRecordSetsResult> changeResourceRecordSetsAsync(final ChangeResourceRecordSetsRequest request, final AsyncHandler<ChangeResourceRecordSetsRequest, ChangeResourceRecordSetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ChangeResourceRecordSetsResult>(){

            @Override
            public ChangeResourceRecordSetsResult call() throws Exception {
                ChangeResourceRecordSetsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.changeResourceRecordSets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ChangeTagsForResourceResult> changeTagsForResourceAsync(ChangeTagsForResourceRequest request) {
        return this.changeTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ChangeTagsForResourceResult> changeTagsForResourceAsync(final ChangeTagsForResourceRequest request, final AsyncHandler<ChangeTagsForResourceRequest, ChangeTagsForResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<ChangeTagsForResourceResult>(){

            @Override
            public ChangeTagsForResourceResult call() throws Exception {
                ChangeTagsForResourceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.changeTagsForResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateHealthCheckResult> createHealthCheckAsync(CreateHealthCheckRequest request) {
        return this.createHealthCheckAsync(request, null);
    }

    @Override
    public Future<CreateHealthCheckResult> createHealthCheckAsync(final CreateHealthCheckRequest request, final AsyncHandler<CreateHealthCheckRequest, CreateHealthCheckResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateHealthCheckResult>(){

            @Override
            public CreateHealthCheckResult call() throws Exception {
                CreateHealthCheckResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createHealthCheck(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateHostedZoneResult> createHostedZoneAsync(CreateHostedZoneRequest request) {
        return this.createHostedZoneAsync(request, null);
    }

    @Override
    public Future<CreateHostedZoneResult> createHostedZoneAsync(final CreateHostedZoneRequest request, final AsyncHandler<CreateHostedZoneRequest, CreateHostedZoneResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateHostedZoneResult>(){

            @Override
            public CreateHostedZoneResult call() throws Exception {
                CreateHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createHostedZone(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateReusableDelegationSetResult> createReusableDelegationSetAsync(CreateReusableDelegationSetRequest request) {
        return this.createReusableDelegationSetAsync(request, null);
    }

    @Override
    public Future<CreateReusableDelegationSetResult> createReusableDelegationSetAsync(final CreateReusableDelegationSetRequest request, final AsyncHandler<CreateReusableDelegationSetRequest, CreateReusableDelegationSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateReusableDelegationSetResult>(){

            @Override
            public CreateReusableDelegationSetResult call() throws Exception {
                CreateReusableDelegationSetResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createReusableDelegationSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTrafficPolicyResult> createTrafficPolicyAsync(CreateTrafficPolicyRequest request) {
        return this.createTrafficPolicyAsync(request, null);
    }

    @Override
    public Future<CreateTrafficPolicyResult> createTrafficPolicyAsync(final CreateTrafficPolicyRequest request, final AsyncHandler<CreateTrafficPolicyRequest, CreateTrafficPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateTrafficPolicyResult>(){

            @Override
            public CreateTrafficPolicyResult call() throws Exception {
                CreateTrafficPolicyResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createTrafficPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTrafficPolicyInstanceResult> createTrafficPolicyInstanceAsync(CreateTrafficPolicyInstanceRequest request) {
        return this.createTrafficPolicyInstanceAsync(request, null);
    }

    @Override
    public Future<CreateTrafficPolicyInstanceResult> createTrafficPolicyInstanceAsync(final CreateTrafficPolicyInstanceRequest request, final AsyncHandler<CreateTrafficPolicyInstanceRequest, CreateTrafficPolicyInstanceResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateTrafficPolicyInstanceResult>(){

            @Override
            public CreateTrafficPolicyInstanceResult call() throws Exception {
                CreateTrafficPolicyInstanceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createTrafficPolicyInstance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTrafficPolicyVersionResult> createTrafficPolicyVersionAsync(CreateTrafficPolicyVersionRequest request) {
        return this.createTrafficPolicyVersionAsync(request, null);
    }

    @Override
    public Future<CreateTrafficPolicyVersionResult> createTrafficPolicyVersionAsync(final CreateTrafficPolicyVersionRequest request, final AsyncHandler<CreateTrafficPolicyVersionRequest, CreateTrafficPolicyVersionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateTrafficPolicyVersionResult>(){

            @Override
            public CreateTrafficPolicyVersionResult call() throws Exception {
                CreateTrafficPolicyVersionResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createTrafficPolicyVersion(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHealthCheckResult> deleteHealthCheckAsync(DeleteHealthCheckRequest request) {
        return this.deleteHealthCheckAsync(request, null);
    }

    @Override
    public Future<DeleteHealthCheckResult> deleteHealthCheckAsync(final DeleteHealthCheckRequest request, final AsyncHandler<DeleteHealthCheckRequest, DeleteHealthCheckResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteHealthCheckResult>(){

            @Override
            public DeleteHealthCheckResult call() throws Exception {
                DeleteHealthCheckResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteHealthCheck(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHostedZoneResult> deleteHostedZoneAsync(DeleteHostedZoneRequest request) {
        return this.deleteHostedZoneAsync(request, null);
    }

    @Override
    public Future<DeleteHostedZoneResult> deleteHostedZoneAsync(final DeleteHostedZoneRequest request, final AsyncHandler<DeleteHostedZoneRequest, DeleteHostedZoneResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteHostedZoneResult>(){

            @Override
            public DeleteHostedZoneResult call() throws Exception {
                DeleteHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteHostedZone(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteReusableDelegationSetResult> deleteReusableDelegationSetAsync(DeleteReusableDelegationSetRequest request) {
        return this.deleteReusableDelegationSetAsync(request, null);
    }

    @Override
    public Future<DeleteReusableDelegationSetResult> deleteReusableDelegationSetAsync(final DeleteReusableDelegationSetRequest request, final AsyncHandler<DeleteReusableDelegationSetRequest, DeleteReusableDelegationSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteReusableDelegationSetResult>(){

            @Override
            public DeleteReusableDelegationSetResult call() throws Exception {
                DeleteReusableDelegationSetResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteReusableDelegationSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTrafficPolicyResult> deleteTrafficPolicyAsync(DeleteTrafficPolicyRequest request) {
        return this.deleteTrafficPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteTrafficPolicyResult> deleteTrafficPolicyAsync(final DeleteTrafficPolicyRequest request, final AsyncHandler<DeleteTrafficPolicyRequest, DeleteTrafficPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteTrafficPolicyResult>(){

            @Override
            public DeleteTrafficPolicyResult call() throws Exception {
                DeleteTrafficPolicyResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteTrafficPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTrafficPolicyInstanceResult> deleteTrafficPolicyInstanceAsync(DeleteTrafficPolicyInstanceRequest request) {
        return this.deleteTrafficPolicyInstanceAsync(request, null);
    }

    @Override
    public Future<DeleteTrafficPolicyInstanceResult> deleteTrafficPolicyInstanceAsync(final DeleteTrafficPolicyInstanceRequest request, final AsyncHandler<DeleteTrafficPolicyInstanceRequest, DeleteTrafficPolicyInstanceResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteTrafficPolicyInstanceResult>(){

            @Override
            public DeleteTrafficPolicyInstanceResult call() throws Exception {
                DeleteTrafficPolicyInstanceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteTrafficPolicyInstance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateVPCFromHostedZoneResult> disassociateVPCFromHostedZoneAsync(DisassociateVPCFromHostedZoneRequest request) {
        return this.disassociateVPCFromHostedZoneAsync(request, null);
    }

    @Override
    public Future<DisassociateVPCFromHostedZoneResult> disassociateVPCFromHostedZoneAsync(final DisassociateVPCFromHostedZoneRequest request, final AsyncHandler<DisassociateVPCFromHostedZoneRequest, DisassociateVPCFromHostedZoneResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisassociateVPCFromHostedZoneResult>(){

            @Override
            public DisassociateVPCFromHostedZoneResult call() throws Exception {
                DisassociateVPCFromHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.disassociateVPCFromHostedZone(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetChangeResult> getChangeAsync(GetChangeRequest request) {
        return this.getChangeAsync(request, null);
    }

    @Override
    public Future<GetChangeResult> getChangeAsync(final GetChangeRequest request, final AsyncHandler<GetChangeRequest, GetChangeResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetChangeResult>(){

            @Override
            public GetChangeResult call() throws Exception {
                GetChangeResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getChange(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<GetChangeDetailsResult> getChangeDetailsAsync(GetChangeDetailsRequest request) {
        return this.getChangeDetailsAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<GetChangeDetailsResult> getChangeDetailsAsync(final GetChangeDetailsRequest request, final AsyncHandler<GetChangeDetailsRequest, GetChangeDetailsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetChangeDetailsResult>(){

            @Override
            public GetChangeDetailsResult call() throws Exception {
                GetChangeDetailsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getChangeDetails(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCheckerIpRangesResult> getCheckerIpRangesAsync(GetCheckerIpRangesRequest request) {
        return this.getCheckerIpRangesAsync(request, null);
    }

    @Override
    public Future<GetCheckerIpRangesResult> getCheckerIpRangesAsync(final GetCheckerIpRangesRequest request, final AsyncHandler<GetCheckerIpRangesRequest, GetCheckerIpRangesResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCheckerIpRangesResult>(){

            @Override
            public GetCheckerIpRangesResult call() throws Exception {
                GetCheckerIpRangesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getCheckerIpRanges(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCheckerIpRangesResult> getCheckerIpRangesAsync() {
        return this.getCheckerIpRangesAsync(new GetCheckerIpRangesRequest());
    }

    @Override
    public Future<GetCheckerIpRangesResult> getCheckerIpRangesAsync(AsyncHandler<GetCheckerIpRangesRequest, GetCheckerIpRangesResult> asyncHandler) {
        return this.getCheckerIpRangesAsync(new GetCheckerIpRangesRequest(), asyncHandler);
    }

    @Override
    public Future<GetGeoLocationResult> getGeoLocationAsync(GetGeoLocationRequest request) {
        return this.getGeoLocationAsync(request, null);
    }

    @Override
    public Future<GetGeoLocationResult> getGeoLocationAsync(final GetGeoLocationRequest request, final AsyncHandler<GetGeoLocationRequest, GetGeoLocationResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetGeoLocationResult>(){

            @Override
            public GetGeoLocationResult call() throws Exception {
                GetGeoLocationResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getGeoLocation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGeoLocationResult> getGeoLocationAsync() {
        return this.getGeoLocationAsync(new GetGeoLocationRequest());
    }

    @Override
    public Future<GetGeoLocationResult> getGeoLocationAsync(AsyncHandler<GetGeoLocationRequest, GetGeoLocationResult> asyncHandler) {
        return this.getGeoLocationAsync(new GetGeoLocationRequest(), asyncHandler);
    }

    @Override
    public Future<GetHealthCheckResult> getHealthCheckAsync(GetHealthCheckRequest request) {
        return this.getHealthCheckAsync(request, null);
    }

    @Override
    public Future<GetHealthCheckResult> getHealthCheckAsync(final GetHealthCheckRequest request, final AsyncHandler<GetHealthCheckRequest, GetHealthCheckResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetHealthCheckResult>(){

            @Override
            public GetHealthCheckResult call() throws Exception {
                GetHealthCheckResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHealthCheck(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetHealthCheckCountResult> getHealthCheckCountAsync(GetHealthCheckCountRequest request) {
        return this.getHealthCheckCountAsync(request, null);
    }

    @Override
    public Future<GetHealthCheckCountResult> getHealthCheckCountAsync(final GetHealthCheckCountRequest request, final AsyncHandler<GetHealthCheckCountRequest, GetHealthCheckCountResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetHealthCheckCountResult>(){

            @Override
            public GetHealthCheckCountResult call() throws Exception {
                GetHealthCheckCountResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHealthCheckCount(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetHealthCheckCountResult> getHealthCheckCountAsync() {
        return this.getHealthCheckCountAsync(new GetHealthCheckCountRequest());
    }

    @Override
    public Future<GetHealthCheckCountResult> getHealthCheckCountAsync(AsyncHandler<GetHealthCheckCountRequest, GetHealthCheckCountResult> asyncHandler) {
        return this.getHealthCheckCountAsync(new GetHealthCheckCountRequest(), asyncHandler);
    }

    @Override
    public Future<GetHealthCheckLastFailureReasonResult> getHealthCheckLastFailureReasonAsync(GetHealthCheckLastFailureReasonRequest request) {
        return this.getHealthCheckLastFailureReasonAsync(request, null);
    }

    @Override
    public Future<GetHealthCheckLastFailureReasonResult> getHealthCheckLastFailureReasonAsync(final GetHealthCheckLastFailureReasonRequest request, final AsyncHandler<GetHealthCheckLastFailureReasonRequest, GetHealthCheckLastFailureReasonResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetHealthCheckLastFailureReasonResult>(){

            @Override
            public GetHealthCheckLastFailureReasonResult call() throws Exception {
                GetHealthCheckLastFailureReasonResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHealthCheckLastFailureReason(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetHealthCheckStatusResult> getHealthCheckStatusAsync(GetHealthCheckStatusRequest request) {
        return this.getHealthCheckStatusAsync(request, null);
    }

    @Override
    public Future<GetHealthCheckStatusResult> getHealthCheckStatusAsync(final GetHealthCheckStatusRequest request, final AsyncHandler<GetHealthCheckStatusRequest, GetHealthCheckStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetHealthCheckStatusResult>(){

            @Override
            public GetHealthCheckStatusResult call() throws Exception {
                GetHealthCheckStatusResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHealthCheckStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetHostedZoneResult> getHostedZoneAsync(GetHostedZoneRequest request) {
        return this.getHostedZoneAsync(request, null);
    }

    @Override
    public Future<GetHostedZoneResult> getHostedZoneAsync(final GetHostedZoneRequest request, final AsyncHandler<GetHostedZoneRequest, GetHostedZoneResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetHostedZoneResult>(){

            @Override
            public GetHostedZoneResult call() throws Exception {
                GetHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHostedZone(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetHostedZoneCountResult> getHostedZoneCountAsync(GetHostedZoneCountRequest request) {
        return this.getHostedZoneCountAsync(request, null);
    }

    @Override
    public Future<GetHostedZoneCountResult> getHostedZoneCountAsync(final GetHostedZoneCountRequest request, final AsyncHandler<GetHostedZoneCountRequest, GetHostedZoneCountResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetHostedZoneCountResult>(){

            @Override
            public GetHostedZoneCountResult call() throws Exception {
                GetHostedZoneCountResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHostedZoneCount(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetHostedZoneCountResult> getHostedZoneCountAsync() {
        return this.getHostedZoneCountAsync(new GetHostedZoneCountRequest());
    }

    @Override
    public Future<GetHostedZoneCountResult> getHostedZoneCountAsync(AsyncHandler<GetHostedZoneCountRequest, GetHostedZoneCountResult> asyncHandler) {
        return this.getHostedZoneCountAsync(new GetHostedZoneCountRequest(), asyncHandler);
    }

    @Override
    public Future<GetReusableDelegationSetResult> getReusableDelegationSetAsync(GetReusableDelegationSetRequest request) {
        return this.getReusableDelegationSetAsync(request, null);
    }

    @Override
    public Future<GetReusableDelegationSetResult> getReusableDelegationSetAsync(final GetReusableDelegationSetRequest request, final AsyncHandler<GetReusableDelegationSetRequest, GetReusableDelegationSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetReusableDelegationSetResult>(){

            @Override
            public GetReusableDelegationSetResult call() throws Exception {
                GetReusableDelegationSetResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getReusableDelegationSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTrafficPolicyResult> getTrafficPolicyAsync(GetTrafficPolicyRequest request) {
        return this.getTrafficPolicyAsync(request, null);
    }

    @Override
    public Future<GetTrafficPolicyResult> getTrafficPolicyAsync(final GetTrafficPolicyRequest request, final AsyncHandler<GetTrafficPolicyRequest, GetTrafficPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTrafficPolicyResult>(){

            @Override
            public GetTrafficPolicyResult call() throws Exception {
                GetTrafficPolicyResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getTrafficPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTrafficPolicyInstanceResult> getTrafficPolicyInstanceAsync(GetTrafficPolicyInstanceRequest request) {
        return this.getTrafficPolicyInstanceAsync(request, null);
    }

    @Override
    public Future<GetTrafficPolicyInstanceResult> getTrafficPolicyInstanceAsync(final GetTrafficPolicyInstanceRequest request, final AsyncHandler<GetTrafficPolicyInstanceRequest, GetTrafficPolicyInstanceResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTrafficPolicyInstanceResult>(){

            @Override
            public GetTrafficPolicyInstanceResult call() throws Exception {
                GetTrafficPolicyInstanceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getTrafficPolicyInstance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTrafficPolicyInstanceCountResult> getTrafficPolicyInstanceCountAsync(GetTrafficPolicyInstanceCountRequest request) {
        return this.getTrafficPolicyInstanceCountAsync(request, null);
    }

    @Override
    public Future<GetTrafficPolicyInstanceCountResult> getTrafficPolicyInstanceCountAsync(final GetTrafficPolicyInstanceCountRequest request, final AsyncHandler<GetTrafficPolicyInstanceCountRequest, GetTrafficPolicyInstanceCountResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTrafficPolicyInstanceCountResult>(){

            @Override
            public GetTrafficPolicyInstanceCountResult call() throws Exception {
                GetTrafficPolicyInstanceCountResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getTrafficPolicyInstanceCount(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTrafficPolicyInstanceCountResult> getTrafficPolicyInstanceCountAsync() {
        return this.getTrafficPolicyInstanceCountAsync(new GetTrafficPolicyInstanceCountRequest());
    }

    @Override
    public Future<GetTrafficPolicyInstanceCountResult> getTrafficPolicyInstanceCountAsync(AsyncHandler<GetTrafficPolicyInstanceCountRequest, GetTrafficPolicyInstanceCountResult> asyncHandler) {
        return this.getTrafficPolicyInstanceCountAsync(new GetTrafficPolicyInstanceCountRequest(), asyncHandler);
    }

    @Override
    @Deprecated
    public Future<ListChangeBatchesByHostedZoneResult> listChangeBatchesByHostedZoneAsync(ListChangeBatchesByHostedZoneRequest request) {
        return this.listChangeBatchesByHostedZoneAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<ListChangeBatchesByHostedZoneResult> listChangeBatchesByHostedZoneAsync(final ListChangeBatchesByHostedZoneRequest request, final AsyncHandler<ListChangeBatchesByHostedZoneRequest, ListChangeBatchesByHostedZoneResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListChangeBatchesByHostedZoneResult>(){

            @Override
            public ListChangeBatchesByHostedZoneResult call() throws Exception {
                ListChangeBatchesByHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listChangeBatchesByHostedZone(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<ListChangeBatchesByRRSetResult> listChangeBatchesByRRSetAsync(ListChangeBatchesByRRSetRequest request) {
        return this.listChangeBatchesByRRSetAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<ListChangeBatchesByRRSetResult> listChangeBatchesByRRSetAsync(final ListChangeBatchesByRRSetRequest request, final AsyncHandler<ListChangeBatchesByRRSetRequest, ListChangeBatchesByRRSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListChangeBatchesByRRSetResult>(){

            @Override
            public ListChangeBatchesByRRSetResult call() throws Exception {
                ListChangeBatchesByRRSetResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listChangeBatchesByRRSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGeoLocationsResult> listGeoLocationsAsync(ListGeoLocationsRequest request) {
        return this.listGeoLocationsAsync(request, null);
    }

    @Override
    public Future<ListGeoLocationsResult> listGeoLocationsAsync(final ListGeoLocationsRequest request, final AsyncHandler<ListGeoLocationsRequest, ListGeoLocationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListGeoLocationsResult>(){

            @Override
            public ListGeoLocationsResult call() throws Exception {
                ListGeoLocationsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listGeoLocations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGeoLocationsResult> listGeoLocationsAsync() {
        return this.listGeoLocationsAsync(new ListGeoLocationsRequest());
    }

    @Override
    public Future<ListGeoLocationsResult> listGeoLocationsAsync(AsyncHandler<ListGeoLocationsRequest, ListGeoLocationsResult> asyncHandler) {
        return this.listGeoLocationsAsync(new ListGeoLocationsRequest(), asyncHandler);
    }

    @Override
    public Future<ListHealthChecksResult> listHealthChecksAsync(ListHealthChecksRequest request) {
        return this.listHealthChecksAsync(request, null);
    }

    @Override
    public Future<ListHealthChecksResult> listHealthChecksAsync(final ListHealthChecksRequest request, final AsyncHandler<ListHealthChecksRequest, ListHealthChecksResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListHealthChecksResult>(){

            @Override
            public ListHealthChecksResult call() throws Exception {
                ListHealthChecksResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listHealthChecks(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHealthChecksResult> listHealthChecksAsync() {
        return this.listHealthChecksAsync(new ListHealthChecksRequest());
    }

    @Override
    public Future<ListHealthChecksResult> listHealthChecksAsync(AsyncHandler<ListHealthChecksRequest, ListHealthChecksResult> asyncHandler) {
        return this.listHealthChecksAsync(new ListHealthChecksRequest(), asyncHandler);
    }

    @Override
    public Future<ListHostedZonesResult> listHostedZonesAsync(ListHostedZonesRequest request) {
        return this.listHostedZonesAsync(request, null);
    }

    @Override
    public Future<ListHostedZonesResult> listHostedZonesAsync(final ListHostedZonesRequest request, final AsyncHandler<ListHostedZonesRequest, ListHostedZonesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListHostedZonesResult>(){

            @Override
            public ListHostedZonesResult call() throws Exception {
                ListHostedZonesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listHostedZones(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHostedZonesResult> listHostedZonesAsync() {
        return this.listHostedZonesAsync(new ListHostedZonesRequest());
    }

    @Override
    public Future<ListHostedZonesResult> listHostedZonesAsync(AsyncHandler<ListHostedZonesRequest, ListHostedZonesResult> asyncHandler) {
        return this.listHostedZonesAsync(new ListHostedZonesRequest(), asyncHandler);
    }

    @Override
    public Future<ListHostedZonesByNameResult> listHostedZonesByNameAsync(ListHostedZonesByNameRequest request) {
        return this.listHostedZonesByNameAsync(request, null);
    }

    @Override
    public Future<ListHostedZonesByNameResult> listHostedZonesByNameAsync(final ListHostedZonesByNameRequest request, final AsyncHandler<ListHostedZonesByNameRequest, ListHostedZonesByNameResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListHostedZonesByNameResult>(){

            @Override
            public ListHostedZonesByNameResult call() throws Exception {
                ListHostedZonesByNameResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listHostedZonesByName(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHostedZonesByNameResult> listHostedZonesByNameAsync() {
        return this.listHostedZonesByNameAsync(new ListHostedZonesByNameRequest());
    }

    @Override
    public Future<ListHostedZonesByNameResult> listHostedZonesByNameAsync(AsyncHandler<ListHostedZonesByNameRequest, ListHostedZonesByNameResult> asyncHandler) {
        return this.listHostedZonesByNameAsync(new ListHostedZonesByNameRequest(), asyncHandler);
    }

    @Override
    public Future<ListResourceRecordSetsResult> listResourceRecordSetsAsync(ListResourceRecordSetsRequest request) {
        return this.listResourceRecordSetsAsync(request, null);
    }

    @Override
    public Future<ListResourceRecordSetsResult> listResourceRecordSetsAsync(final ListResourceRecordSetsRequest request, final AsyncHandler<ListResourceRecordSetsRequest, ListResourceRecordSetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListResourceRecordSetsResult>(){

            @Override
            public ListResourceRecordSetsResult call() throws Exception {
                ListResourceRecordSetsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listResourceRecordSets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReusableDelegationSetsResult> listReusableDelegationSetsAsync(ListReusableDelegationSetsRequest request) {
        return this.listReusableDelegationSetsAsync(request, null);
    }

    @Override
    public Future<ListReusableDelegationSetsResult> listReusableDelegationSetsAsync(final ListReusableDelegationSetsRequest request, final AsyncHandler<ListReusableDelegationSetsRequest, ListReusableDelegationSetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListReusableDelegationSetsResult>(){

            @Override
            public ListReusableDelegationSetsResult call() throws Exception {
                ListReusableDelegationSetsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listReusableDelegationSets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReusableDelegationSetsResult> listReusableDelegationSetsAsync() {
        return this.listReusableDelegationSetsAsync(new ListReusableDelegationSetsRequest());
    }

    @Override
    public Future<ListReusableDelegationSetsResult> listReusableDelegationSetsAsync(AsyncHandler<ListReusableDelegationSetsRequest, ListReusableDelegationSetsResult> asyncHandler) {
        return this.listReusableDelegationSetsAsync(new ListReusableDelegationSetsRequest(), asyncHandler);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTagsForResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourcesResult> listTagsForResourcesAsync(ListTagsForResourcesRequest request) {
        return this.listTagsForResourcesAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourcesResult> listTagsForResourcesAsync(final ListTagsForResourcesRequest request, final AsyncHandler<ListTagsForResourcesRequest, ListTagsForResourcesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTagsForResourcesResult>(){

            @Override
            public ListTagsForResourcesResult call() throws Exception {
                ListTagsForResourcesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTagsForResources(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTrafficPoliciesResult> listTrafficPoliciesAsync(ListTrafficPoliciesRequest request) {
        return this.listTrafficPoliciesAsync(request, null);
    }

    @Override
    public Future<ListTrafficPoliciesResult> listTrafficPoliciesAsync(final ListTrafficPoliciesRequest request, final AsyncHandler<ListTrafficPoliciesRequest, ListTrafficPoliciesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTrafficPoliciesResult>(){

            @Override
            public ListTrafficPoliciesResult call() throws Exception {
                ListTrafficPoliciesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTrafficPolicies(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTrafficPoliciesResult> listTrafficPoliciesAsync() {
        return this.listTrafficPoliciesAsync(new ListTrafficPoliciesRequest());
    }

    @Override
    public Future<ListTrafficPoliciesResult> listTrafficPoliciesAsync(AsyncHandler<ListTrafficPoliciesRequest, ListTrafficPoliciesResult> asyncHandler) {
        return this.listTrafficPoliciesAsync(new ListTrafficPoliciesRequest(), asyncHandler);
    }

    @Override
    public Future<ListTrafficPolicyInstancesResult> listTrafficPolicyInstancesAsync(ListTrafficPolicyInstancesRequest request) {
        return this.listTrafficPolicyInstancesAsync(request, null);
    }

    @Override
    public Future<ListTrafficPolicyInstancesResult> listTrafficPolicyInstancesAsync(final ListTrafficPolicyInstancesRequest request, final AsyncHandler<ListTrafficPolicyInstancesRequest, ListTrafficPolicyInstancesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTrafficPolicyInstancesResult>(){

            @Override
            public ListTrafficPolicyInstancesResult call() throws Exception {
                ListTrafficPolicyInstancesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTrafficPolicyInstances(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTrafficPolicyInstancesResult> listTrafficPolicyInstancesAsync() {
        return this.listTrafficPolicyInstancesAsync(new ListTrafficPolicyInstancesRequest());
    }

    @Override
    public Future<ListTrafficPolicyInstancesResult> listTrafficPolicyInstancesAsync(AsyncHandler<ListTrafficPolicyInstancesRequest, ListTrafficPolicyInstancesResult> asyncHandler) {
        return this.listTrafficPolicyInstancesAsync(new ListTrafficPolicyInstancesRequest(), asyncHandler);
    }

    @Override
    public Future<ListTrafficPolicyInstancesByHostedZoneResult> listTrafficPolicyInstancesByHostedZoneAsync(ListTrafficPolicyInstancesByHostedZoneRequest request) {
        return this.listTrafficPolicyInstancesByHostedZoneAsync(request, null);
    }

    @Override
    public Future<ListTrafficPolicyInstancesByHostedZoneResult> listTrafficPolicyInstancesByHostedZoneAsync(final ListTrafficPolicyInstancesByHostedZoneRequest request, final AsyncHandler<ListTrafficPolicyInstancesByHostedZoneRequest, ListTrafficPolicyInstancesByHostedZoneResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTrafficPolicyInstancesByHostedZoneResult>(){

            @Override
            public ListTrafficPolicyInstancesByHostedZoneResult call() throws Exception {
                ListTrafficPolicyInstancesByHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTrafficPolicyInstancesByHostedZone(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTrafficPolicyInstancesByPolicyResult> listTrafficPolicyInstancesByPolicyAsync(ListTrafficPolicyInstancesByPolicyRequest request) {
        return this.listTrafficPolicyInstancesByPolicyAsync(request, null);
    }

    @Override
    public Future<ListTrafficPolicyInstancesByPolicyResult> listTrafficPolicyInstancesByPolicyAsync(final ListTrafficPolicyInstancesByPolicyRequest request, final AsyncHandler<ListTrafficPolicyInstancesByPolicyRequest, ListTrafficPolicyInstancesByPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTrafficPolicyInstancesByPolicyResult>(){

            @Override
            public ListTrafficPolicyInstancesByPolicyResult call() throws Exception {
                ListTrafficPolicyInstancesByPolicyResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTrafficPolicyInstancesByPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTrafficPolicyVersionsResult> listTrafficPolicyVersionsAsync(ListTrafficPolicyVersionsRequest request) {
        return this.listTrafficPolicyVersionsAsync(request, null);
    }

    @Override
    public Future<ListTrafficPolicyVersionsResult> listTrafficPolicyVersionsAsync(final ListTrafficPolicyVersionsRequest request, final AsyncHandler<ListTrafficPolicyVersionsRequest, ListTrafficPolicyVersionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTrafficPolicyVersionsResult>(){

            @Override
            public ListTrafficPolicyVersionsResult call() throws Exception {
                ListTrafficPolicyVersionsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTrafficPolicyVersions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TestDNSAnswerResult> testDNSAnswerAsync(TestDNSAnswerRequest request) {
        return this.testDNSAnswerAsync(request, null);
    }

    @Override
    public Future<TestDNSAnswerResult> testDNSAnswerAsync(final TestDNSAnswerRequest request, final AsyncHandler<TestDNSAnswerRequest, TestDNSAnswerResult> asyncHandler) {
        return this.executorService.submit(new Callable<TestDNSAnswerResult>(){

            @Override
            public TestDNSAnswerResult call() throws Exception {
                TestDNSAnswerResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.testDNSAnswer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateHealthCheckResult> updateHealthCheckAsync(UpdateHealthCheckRequest request) {
        return this.updateHealthCheckAsync(request, null);
    }

    @Override
    public Future<UpdateHealthCheckResult> updateHealthCheckAsync(final UpdateHealthCheckRequest request, final AsyncHandler<UpdateHealthCheckRequest, UpdateHealthCheckResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateHealthCheckResult>(){

            @Override
            public UpdateHealthCheckResult call() throws Exception {
                UpdateHealthCheckResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.updateHealthCheck(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateHostedZoneCommentResult> updateHostedZoneCommentAsync(UpdateHostedZoneCommentRequest request) {
        return this.updateHostedZoneCommentAsync(request, null);
    }

    @Override
    public Future<UpdateHostedZoneCommentResult> updateHostedZoneCommentAsync(final UpdateHostedZoneCommentRequest request, final AsyncHandler<UpdateHostedZoneCommentRequest, UpdateHostedZoneCommentResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateHostedZoneCommentResult>(){

            @Override
            public UpdateHostedZoneCommentResult call() throws Exception {
                UpdateHostedZoneCommentResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.updateHostedZoneComment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTrafficPolicyCommentResult> updateTrafficPolicyCommentAsync(UpdateTrafficPolicyCommentRequest request) {
        return this.updateTrafficPolicyCommentAsync(request, null);
    }

    @Override
    public Future<UpdateTrafficPolicyCommentResult> updateTrafficPolicyCommentAsync(final UpdateTrafficPolicyCommentRequest request, final AsyncHandler<UpdateTrafficPolicyCommentRequest, UpdateTrafficPolicyCommentResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateTrafficPolicyCommentResult>(){

            @Override
            public UpdateTrafficPolicyCommentResult call() throws Exception {
                UpdateTrafficPolicyCommentResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.updateTrafficPolicyComment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTrafficPolicyInstanceResult> updateTrafficPolicyInstanceAsync(UpdateTrafficPolicyInstanceRequest request) {
        return this.updateTrafficPolicyInstanceAsync(request, null);
    }

    @Override
    public Future<UpdateTrafficPolicyInstanceResult> updateTrafficPolicyInstanceAsync(final UpdateTrafficPolicyInstanceRequest request, final AsyncHandler<UpdateTrafficPolicyInstanceRequest, UpdateTrafficPolicyInstanceResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateTrafficPolicyInstanceResult>(){

            @Override
            public UpdateTrafficPolicyInstanceResult call() throws Exception {
                UpdateTrafficPolicyInstanceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.updateTrafficPolicyInstance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

