/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.AttributePayload;
import java.util.Map;

public class AttributePayloadJsonMarshaller {
    private static AttributePayloadJsonMarshaller instance;

    public void marshall(AttributePayload attributePayload, StructuredJsonGenerator jsonGenerator) {
        if (attributePayload == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            Map<String, String> attributesMap = attributePayload.getAttributes();
            if (attributesMap != null) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(attributesMapValue.getKey());
                    jsonGenerator.writeValue(attributesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (attributePayload.getMerge() != null) {
                jsonGenerator.writeFieldName("merge").writeValue(attributePayload.getMerge());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AttributePayloadJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AttributePayloadJsonMarshaller();
        }
        return instance;
    }
}

