/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import com.amazonaws.services.elasticbeanstalk.model.SourceBuildInformation;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateApplicationVersionRequestMarshaller
implements Marshaller<Request<CreateApplicationVersionRequest>, CreateApplicationVersionRequest> {
    @Override
    public Request<CreateApplicationVersionRequest> marshall(CreateApplicationVersionRequest createApplicationVersionRequest) {
        S3Location sourceBundle;
        SourceBuildInformation sourceBuildInformation;
        if (createApplicationVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateApplicationVersionRequest> request = new DefaultRequest<CreateApplicationVersionRequest>(createApplicationVersionRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreateApplicationVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createApplicationVersionRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString(createApplicationVersionRequest.getApplicationName()));
        }
        if (createApplicationVersionRequest.getVersionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString(createApplicationVersionRequest.getVersionLabel()));
        }
        if (createApplicationVersionRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createApplicationVersionRequest.getDescription()));
        }
        if ((sourceBuildInformation = createApplicationVersionRequest.getSourceBuildInformation()) != null) {
            if (sourceBuildInformation.getSourceType() != null) {
                request.addParameter("SourceBuildInformation.SourceType", StringUtils.fromString(sourceBuildInformation.getSourceType()));
            }
            if (sourceBuildInformation.getSourceRepository() != null) {
                request.addParameter("SourceBuildInformation.SourceRepository", StringUtils.fromString(sourceBuildInformation.getSourceRepository()));
            }
            if (sourceBuildInformation.getSourceLocation() != null) {
                request.addParameter("SourceBuildInformation.SourceLocation", StringUtils.fromString(sourceBuildInformation.getSourceLocation()));
            }
        }
        if ((sourceBundle = createApplicationVersionRequest.getSourceBundle()) != null) {
            if (sourceBundle.getS3Bucket() != null) {
                request.addParameter("SourceBundle.S3Bucket", StringUtils.fromString(sourceBundle.getS3Bucket()));
            }
            if (sourceBundle.getS3Key() != null) {
                request.addParameter("SourceBundle.S3Key", StringUtils.fromString(sourceBundle.getS3Key()));
            }
        }
        if (createApplicationVersionRequest.getAutoCreateApplication() != null) {
            request.addParameter("AutoCreateApplication", StringUtils.fromBoolean(createApplicationVersionRequest.getAutoCreateApplication()));
        }
        if (createApplicationVersionRequest.getProcess() != null) {
            request.addParameter("Process", StringUtils.fromBoolean(createApplicationVersionRequest.getProcess()));
        }
        return request;
    }
}

