/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.PrefixListId;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AuthorizeSecurityGroupEgressRequestMarshaller
implements Marshaller<Request<AuthorizeSecurityGroupEgressRequest>, AuthorizeSecurityGroupEgressRequest> {
    @Override
    public Request<AuthorizeSecurityGroupEgressRequest> marshall(AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest) {
        SdkInternalList authorizeSecurityGroupEgressRequestIpPermissionsList;
        if (authorizeSecurityGroupEgressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AuthorizeSecurityGroupEgressRequest> request = new DefaultRequest<AuthorizeSecurityGroupEgressRequest>(authorizeSecurityGroupEgressRequest, "AmazonEC2");
        request.addParameter("Action", "AuthorizeSecurityGroupEgress");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeSecurityGroupEgressRequest.getGroupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString(authorizeSecurityGroupEgressRequest.getGroupId()));
        }
        if (authorizeSecurityGroupEgressRequest.getSourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString(authorizeSecurityGroupEgressRequest.getSourceSecurityGroupName()));
        }
        if (authorizeSecurityGroupEgressRequest.getSourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString(authorizeSecurityGroupEgressRequest.getSourceSecurityGroupOwnerId()));
        }
        if (authorizeSecurityGroupEgressRequest.getIpProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString(authorizeSecurityGroupEgressRequest.getIpProtocol()));
        }
        if (authorizeSecurityGroupEgressRequest.getFromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger(authorizeSecurityGroupEgressRequest.getFromPort()));
        }
        if (authorizeSecurityGroupEgressRequest.getToPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger(authorizeSecurityGroupEgressRequest.getToPort()));
        }
        if (authorizeSecurityGroupEgressRequest.getCidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString(authorizeSecurityGroupEgressRequest.getCidrIp()));
        }
        if (!(authorizeSecurityGroupEgressRequestIpPermissionsList = (SdkInternalList)authorizeSecurityGroupEgressRequest.getIpPermissions()).isEmpty() || !authorizeSecurityGroupEgressRequestIpPermissionsList.isAutoConstruct()) {
            int ipPermissionsListIndex = 1;
            for (IpPermission authorizeSecurityGroupEgressRequestIpPermissionsListValue : authorizeSecurityGroupEgressRequestIpPermissionsList) {
                SdkInternalList ipPermissionPrefixListIdsList;
                SdkInternalList ipPermissionIpRangesList;
                SdkInternalList ipPermissionUserIdGroupPairsList;
                if (authorizeSecurityGroupEgressRequestIpPermissionsListValue.getIpProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString(authorizeSecurityGroupEgressRequestIpPermissionsListValue.getIpProtocol()));
                }
                if (authorizeSecurityGroupEgressRequestIpPermissionsListValue.getFromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger(authorizeSecurityGroupEgressRequestIpPermissionsListValue.getFromPort()));
                }
                if (authorizeSecurityGroupEgressRequestIpPermissionsListValue.getToPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger(authorizeSecurityGroupEgressRequestIpPermissionsListValue.getToPort()));
                }
                if (!(ipPermissionUserIdGroupPairsList = (SdkInternalList)authorizeSecurityGroupEgressRequestIpPermissionsListValue.getUserIdGroupPairs()).isEmpty() || !ipPermissionUserIdGroupPairsList.isAutoConstruct()) {
                    int userIdGroupPairsListIndex = 1;
                    for (Object ipPermissionUserIdGroupPairsListValue : ipPermissionUserIdGroupPairsList) {
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getUserId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".UserId", StringUtils.fromString(((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getUserId()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getGroupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupName", StringUtils.fromString(((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getGroupName()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getGroupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupId", StringUtils.fromString(((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getGroupId()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getVpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcId", StringUtils.fromString(((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getVpcId()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getVpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcPeeringConnectionId", StringUtils.fromString(((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getVpcPeeringConnectionId()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getPeeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".PeeringStatus", StringUtils.fromString(((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getPeeringStatus()));
                        }
                        ++userIdGroupPairsListIndex;
                    }
                }
                if (!(ipPermissionIpRangesList = (SdkInternalList)authorizeSecurityGroupEgressRequestIpPermissionsListValue.getIpRanges()).isEmpty() || !ipPermissionIpRangesList.isAutoConstruct()) {
                    Object ipPermissionUserIdGroupPairsListValue;
                    int ipRangesListIndex = 1;
                    ipPermissionUserIdGroupPairsListValue = ipPermissionIpRangesList.iterator();
                    while (ipPermissionUserIdGroupPairsListValue.hasNext()) {
                        String ipPermissionIpRangesListValue = (String)ipPermissionUserIdGroupPairsListValue.next();
                        if (ipPermissionIpRangesListValue != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipRangesListIndex + ".CidrIp", StringUtils.fromString(ipPermissionIpRangesListValue));
                        }
                        ++ipRangesListIndex;
                    }
                }
                if (!(ipPermissionPrefixListIdsList = (SdkInternalList)authorizeSecurityGroupEgressRequestIpPermissionsListValue.getPrefixListIds()).isEmpty() || !ipPermissionPrefixListIdsList.isAutoConstruct()) {
                    int prefixListIdsListIndex = 1;
                    for (PrefixListId ipPermissionPrefixListIdsListValue : ipPermissionPrefixListIdsList) {
                        if (ipPermissionPrefixListIdsListValue.getPrefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString(ipPermissionPrefixListIdsListValue.getPrefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        return request;
    }
}

