/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetDeploymentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetDeploymentRequestMarshaller
implements Marshaller<Request<GetDeploymentRequest>, GetDeploymentRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetDeploymentRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetDeploymentRequest> marshall(GetDeploymentRequest getDeploymentRequest) {
        if (getDeploymentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDeploymentRequest> request = new DefaultRequest<GetDeploymentRequest>(getDeploymentRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/deployments/{deployment_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getDeploymentRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getDeploymentRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{deployment_id}", getDeploymentRequest.getDeploymentId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getDeploymentRequest.getDeploymentId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

